/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services;

import io.continual.services.ConfigObject;
import io.continual.services.ProfileConfig;
import io.continual.services.ServiceConfig;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.data.json.JsonVisitor;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceSet {
    private boolean fInited = false;
    private ConfigObject config = new ConfigObject();
    private LinkedList<ServiceConfig> services = new LinkedList();
    private HashMap<String, ProfileConfig> profiles = new HashMap();
    private HashMap<String, ServiceConfig> servicesByName = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(ServiceSet.class);

    public static ServiceSet readConfig(Reader r) {
        JSONObject top = new JSONObject((JSONTokener)new CommentedJsonTokener(r));
        final ServiceSet ss = new ServiceSet().useConfiguration(ConfigObject.read(top.optJSONObject("config")));
        JsonVisitor.forEachElement((JSONObject)top.optJSONObject("profiles"), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONObject, JSONException>(){

            public boolean visit(String key, JSONObject sc) throws JSONException {
                ProfileConfig pc = ProfileConfig.read(sc);
                ss.profiles.put(key, pc);
                return true;
            }
        });
        JsonVisitor.forEachElement((JSONArray)top.optJSONArray("services"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, JSONException>(){

            public boolean visit(JSONObject sc) throws JSONException {
                ss.hostingService(ServiceConfig.read(sc));
                return true;
            }
        });
        return ss;
    }

    public void applyProfile(String profile) {
        this.init();
        ProfileConfig pc = this.profiles.get(profile);
        if (pc != null) {
            for (ServiceConfig sc : this.services) {
                sc.overwrite(pc);
            }
        } else {
            log.warn("Profile [" + profile + "] is not in the configuration.");
        }
    }

    public ServiceConfig getService(String named) {
        this.init();
        return this.servicesByName.get(named);
    }

    public Collection<ServiceConfig> getServices() {
        this.init();
        return new LinkedList<ServiceConfig>(this.services);
    }

    private synchronized void init() {
        if (!this.fInited) {
            this.fInited = true;
            for (ServiceConfig sc : this.services) {
                sc.setBaseConfig(this.config);
                this.servicesByName.put(sc.getName(), sc);
            }
        }
    }

    public ServiceSet useConfiguration(ConfigObject co) {
        this.config = co;
        return this;
    }

    public ServiceSet hostingService(ServiceConfig sc) {
        this.services.add(sc);
        return this;
    }
}

