/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services;

import io.continual.resources.ResourceLoader;
import io.continual.services.Service;
import io.continual.services.ServiceContainer;
import io.continual.services.ServiceContainerFactory;
import io.continual.util.console.CmdLineParser;
import io.continual.util.console.CmdLinePrefs;
import io.continual.util.console.ConsoleProgram;
import io.continual.util.console.DaemonConsole;
import io.continual.util.nv.NvReadable;
import io.continual.util.nv.NvWriteable;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server<T extends ServiceContainer>
extends DaemonConsole {
    public static final String kServices = "services";
    public static final String kServicesChar = "s";
    public static final String kProfile = "profile";
    public static final String kProfileChar = "p";
    private final ServiceContainerFactory<T> fFactory;
    private ServiceContainer fServices;
    private boolean fHideCopyrights = false;
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    private static final String[] kGreeting1 = new String[]{". . . . . . . . . . . . . . . . . . . . . . . . . . .", "PROGNAME"};
    private static final String[] kGreeting2 = new String[]{". . . . . . . . . . . . . . . . . . . . . . . . . . ."};

    protected Server(String programName, ServiceContainerFactory<T> factory) {
        super(programName);
        this.fFactory = factory;
        this.fServices = null;
    }

    protected Server<T> setupDefaults(NvWriteable pt) {
        pt.set(kServices, "services.json");
        return this;
    }

    protected Server<T> setupOptions(CmdLineParser p) {
        super.setupOptions(p);
        p.registerOptionWithValue(kServices, kServicesChar, null, null);
        p.registerOptionWithValue(kProfile, kProfileChar, null, null);
        return this;
    }

    protected ConsoleProgram.Looper init(NvReadable p, CmdLinePrefs clp) throws NvReadable.MissingReqdSettingException, NvReadable.InvalidSettingValueException, ConsoleProgram.StartupFailureException {
        super.quietStartup();
        for (String string : this.getPreCopyrightGreeting()) {
            log.info(string.replaceAll("PROGNAME", this.getProgramName()));
        }
        if (!this.fHideCopyrights) {
            for (String notice : this.getCopyrightLines()) {
                log.info(notice);
            }
        }
        for (String string : this.getPostCopyrightGreeting()) {
            log.info(string.replaceAll("PROGNAME", this.getProgramName()));
        }
        ConsoleProgram.Looper result = super.init(p, clp);
        String services = p.get(kServices);
        if (services == null) {
            log.warn("No services configuration name provided.");
        } else {
            log.info("Loading services from [" + services + "]...");
            try {
                Throwable throwable = null;
                try (InputStream serviceStream = ResourceLoader.load(services);){
                    if (serviceStream != null) {
                        this.fServices = ServiceContainer.build(serviceStream, p.getStrings(kProfile, new String[]{"default"}), true, this.fFactory);
                        this.runOnceOnStart(p, clp, this.fServices);
                    } else {
                        log.warn("Couldn't find resource " + services + ".");
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                log.warn("Couldn't open " + services + " as a stream.");
            }
            if (this.fServices == null) {
                log.warn("No services loaded from " + services);
            }
        }
        return result;
    }

    protected void runOnceOnStart(NvReadable prefs, CmdLinePrefs cmdLine, ServiceContainer svcs) {
    }

    protected void shutdown() throws InterruptedException {
        this.fServices.stopAll();
        this.fServices.awaitTermination();
    }

    protected boolean daemonStillRunning() {
        if (this.fServices != null) {
            for (Service sc : this.fServices.getServices()) {
                if (!sc.isRunning()) continue;
                return true;
            }
        }
        log.info("No services running.");
        return false;
    }

    protected void hideCopyrights() {
        this.fHideCopyrights = true;
    }

    protected ServiceContainer getServices() {
        return this.fServices;
    }

    public static void runServer(String programName, String[] args) throws Exception {
        Server.runServer(programName, new StdFactory(), args);
    }

    public static <T extends ServiceContainer> void runServer(String programName, ServiceContainerFactory<T> factory, String[] args) throws Exception {
        new Server<T>(programName, factory).runFromMain(args);
    }

    protected String[] getPreCopyrightGreeting() {
        return kGreeting1;
    }

    protected String[] getPostCopyrightGreeting() {
        return kGreeting2;
    }

    public static class StdFactory
    implements ServiceContainerFactory<ServiceContainer> {
        @Override
        public ServiceContainer create() {
            return new ServiceContainer();
        }
    }
}

