/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.routing.playish;

import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.routing.playish.CHttpPlayishRouteHandler;
import io.continual.resources.ResourceLoader;
import io.continual.util.data.StreamTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticDirHandler
implements CHttpPlayishRouteHandler {
    public static final String kSetting_CacheMaxAge = "chttp.staticFile.cache.maxAgeSeconds";
    public static final int kDefault_CacheMaxAge = -1;
    private final String fRoutedPath;
    private final String fDir;
    private final String fDefaultPage;
    private final int fCacheMaxAge;
    private static final Logger log = LoggerFactory.getLogger(StaticDirHandler.class);
    static final HashMap<String, String> sfContentTypes = new HashMap();

    public StaticDirHandler(String routedPath, String staticDirInfo) {
        this(routedPath, staticDirInfo, -1);
    }

    public StaticDirHandler(String routedPath, String staticDirInfo, int maxCacheAge) {
        String[] parts = staticDirInfo.split(";");
        if (parts.length < 1) {
            throw new IllegalArgumentException("dir[;defaultpage]");
        }
        this.fRoutedPath = routedPath;
        this.fDir = parts[0];
        this.fDefaultPage = parts.length > 1 ? parts[1] : null;
        this.fCacheMaxAge = maxCacheAge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(CHttpRequestContext context, List<String> args) throws IOException {
        String path = context.request().getPathInContext();
        if (path == null || path.length() == 0) {
            log.warn("[" + path + "] no path provided");
            context.response().sendError(404, "no path provided");
            return;
        }
        if (path.contains("..")) {
            log.warn("[" + path + "] contains parent directory accessor");
            context.response().sendError(400, path + " was not found on this server.");
            return;
        }
        if (!path.startsWith(this.fRoutedPath)) {
            log.warn("[" + path + "] does not start with routed path [" + this.fRoutedPath + "]");
            context.response().sendError(500, path + " is not a matching path");
            return;
        }
        String relPath = path.substring(this.fRoutedPath.length());
        String newPath = (relPath.length() == 0 || relPath.equals("/")) && this.fDefaultPage != null ? this.fDir + File.separator + this.fDefaultPage : this.fDir + File.separator + relPath;
        log.info("finding stream [" + newPath + "]");
        InputStream is = new ResourceLoader().usingStandardSources(true, this.getClass()).named(newPath).load();
        log.info("Path [" + path + "] ==> [" + (is == null ? "<not found>" : newPath) + "].");
        if (is == null) {
            context.response().sendError(404, path + " was not found on this server.");
        } else {
            String contentType = StaticDirHandler.mapToContentType(newPath);
            if (this.fCacheMaxAge > 0) {
                context.response().writeHeader("Cache-Control", "max-age=" + this.fCacheMaxAge, true);
            }
            try {
                StreamTools.copyStream((InputStream)is, (OutputStream)context.response().getStreamForBinaryResponse(contentType));
            }
            finally {
                is.close();
            }
        }
    }

    public static String mapToContentType(String name) {
        String result;
        int dot = name.lastIndexOf(".");
        if (dot != -1) {
            name = name.substring(dot + 1);
        }
        if ((result = sfContentTypes.get(name)) == null) {
            log.warn("Unknown content type [" + name + "]. Sending text/plain. (See " + StaticDirHandler.class.getSimpleName() + "::sfContentTypes)");
            result = "text/plain";
        }
        return result;
    }

    @Override
    public boolean actionMatches(String fullPath) {
        return false;
    }

    static {
        sfContentTypes.put("css", "text/css");
        sfContentTypes.put("jpg", "image/jpg");
        sfContentTypes.put("jpeg", "image/jpg");
        sfContentTypes.put("gif", "image/gif");
        sfContentTypes.put("png", "image/png");
        sfContentTypes.put("ico", "image/vnd.microsoft.icon");
        sfContentTypes.put("htm", "text/html");
        sfContentTypes.put("html", "text/html");
        sfContentTypes.put("txt", "text/plain");
        sfContentTypes.put("log", "text/plain");
        sfContentTypes.put("js", "application/javascript");
        sfContentTypes.put("json", "application/json");
        sfContentTypes.put("eot", "application/vnd.ms-fontobject");
        sfContentTypes.put("woff", "application/x-font-woff");
        sfContentTypes.put("woff2", "application/x-font-woff2");
        sfContentTypes.put("otf", "application/font-otf");
        sfContentTypes.put("ttf", "application/x-font-ttf");
        sfContentTypes.put("svg", "image/svg+xml");
        sfContentTypes.put("xml", "application/xml");
        sfContentTypes.put("sh", "application/octet-stream");
    }
}

