/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.routing.playish;

import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.routing.CHttpRouteInvocation;
import io.continual.http.service.framework.routing.CHttpRouteSource;
import io.continual.http.service.framework.routing.playish.CHttpPathInfo;
import io.continual.http.service.framework.routing.playish.RedirectHandler;
import io.continual.http.service.framework.routing.playish.StaticDirHandler;
import io.continual.http.service.framework.routing.playish.StaticFileHandler;
import io.continual.http.service.framework.routing.playish.StaticJavaEntryAction;
import io.continual.util.naming.Path;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHttpPlayishStaticEntryPointRoutingSource
implements CHttpRouteSource {
    private final LinkedList<String> fPackages;
    private final LinkedList<CHttpPathInfo> fPathList = new LinkedList();
    private static final Logger log = LoggerFactory.getLogger(CHttpPlayishStaticEntryPointRoutingSource.class);
    private static final String kStaticDirTag = "staticDir:";
    private static final String kStaticFileTag = "staticFile:";
    private static final String kRedirectTag = "redirect:";

    public CHttpPlayishStaticEntryPointRoutingSource() {
        this.fPackages = new LinkedList();
    }

    public synchronized CHttpPlayishStaticEntryPointRoutingSource addRoute(String verb, String path, String action) {
        if (action.startsWith(kStaticDirTag)) {
            CHttpPathInfo pe = CHttpPathInfo.processPath(verb, path + ".*");
            pe.setHandler(new StaticDirHandler(path, action.substring(kStaticDirTag.length())));
            this.fPathList.add(pe);
        } else if (action.startsWith(kStaticFileTag)) {
            CHttpPathInfo pe = CHttpPathInfo.processPath(verb, path);
            pe.setHandler(new StaticFileHandler(path, action.substring(kStaticFileTag.length())));
            this.fPathList.add(pe);
        } else if (action.startsWith(kRedirectTag)) {
            CHttpPathInfo pe = CHttpPathInfo.processPath(verb, path);
            String loc = action.substring(kRedirectTag.length());
            pe.setHandler(new RedirectHandler(loc));
            this.fPathList.add(pe);
        } else {
            CHttpPathInfo pe = CHttpPathInfo.processPath(verb, path);
            pe.setHandler(new StaticJavaEntryAction(action, pe.getArgs(), this.fPackages));
            this.fPathList.add(pe);
        }
        return this;
    }

    @Override
    public synchronized CHttpRouteInvocation getRouteFor(String verb, String path) {
        Invocation selected = null;
        for (CHttpPathInfo pe : this.fPathList) {
            List<String> args = pe.matches(verb, path);
            if (args == null) continue;
            selected = this.getInvocation(pe, args);
            break;
        }
        return selected;
    }

    @Override
    public String getRouteTo(Class<?> c, String staticMethodName, Map<String, Object> args) {
        String fullname = c.getName() + "." + staticMethodName;
        for (CHttpPathInfo pe : this.fPathList) {
            if (!pe.invokes(fullname)) continue;
            return pe.makePath(args);
        }
        return null;
    }

    protected Invocation getInvocation(CHttpPathInfo pe, List<String> args) {
        return new Invocation(pe, args);
    }

    protected synchronized void clearRoutes() {
        log.debug("Clearing routes within this static route source.");
        this.fPathList.clear();
    }

    protected synchronized void addPackage(String pkg) {
        this.fPackages.add(pkg);
    }

    protected class Invocation
    implements CHttpRouteInvocation {
        private final CHttpPathInfo fPe;
        private final List<String> fArgs;

        public Invocation(CHttpPathInfo pe, List<String> args) {
            this.fPe = pe;
            this.fArgs = args;
        }

        @Override
        public void run(CHttpRequestContext ctx) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.fPe.getHandler().handle(ctx, this.fArgs);
        }

        @Override
        public Path getRouteNameForMetrics() {
            String pathPart = this.fPe.getPath();
            if (!pathPart.startsWith("/")) {
                pathPart = "/" + pathPart;
            }
            return Path.fromString((String)("/" + this.fPe.getVerb() + pathPart));
        }
    }
}

