/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.inspection.impl;

import io.continual.http.service.framework.context.CHttpRequest;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.inspection.CHttpObserver;
import io.continual.http.service.framework.inspection.CHttpObserverMgr;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.util.data.TypeConvertor;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.time.Clock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHttpTrxObserver
extends SimpleService
implements CHttpObserverMgr {
    private final File fBaseDir;
    private final LinkedList<Filter> fFilters = new LinkedList();
    private static final Logger log = LoggerFactory.getLogger(CHttpTrxObserver.class);

    public CHttpTrxObserver(File baseDir) {
        this.fBaseDir = baseDir;
    }

    public CHttpTrxObserver(ServiceContainer sc, JSONObject config) {
        this.fBaseDir = new File(config.optString("baseDir", "./logs"));
        JsonVisitor.forEachElement((JSONArray)config.optJSONArray("filters"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, JSONException>(){

            public boolean visit(JSONObject filter) throws JSONException {
                final String logName = filter.getString("logName");
                final String method = filter.optString("method", ".*");
                final String path = filter.optString("path", ".*");
                CHttpTrxObserver.this.addFilter(new Filter(){

                    @Override
                    public String logName() {
                        return logName;
                    }

                    @Override
                    public boolean matches(CHttpRequestContext ctx) {
                        CHttpRequest req = ctx.request();
                        String reqMethod = req.getMethod();
                        String reqPath = req.getPathInContext();
                        return reqMethod.matches(method) && reqPath.matches(path);
                    }
                });
                return true;
            }
        });
    }

    @Override
    public void consider(CHttpRequestContext ctx) {
        for (Filter f : this.fFilters) {
            if (!f.matches(ctx)) continue;
            try {
                String name = f.logName() + "." + Clock.now() + ".log";
                ctx.install(new TrxDumper(new PrintWriter(new FileOutputStream(new File(this.fBaseDir, name), true))));
            }
            catch (IOException e) {
                log.warn("Couldn't install inspector on trx: " + e.getMessage());
            }
            return;
        }
    }

    public List<Filter> getFilters() {
        return Collections.unmodifiableList(this.fFilters);
    }

    public CHttpObserverMgr addFilter(Filter f) {
        this.fFilters.add(f);
        return this;
    }

    public CHttpObserverMgr removeFilter(Filter f) {
        this.fFilters.remove(f);
        return this;
    }

    private class TracingPrintWriter
    extends PrintWriter {
        private final PrintWriter fLog;

        public TracingPrintWriter(PrintWriter to, PrintWriter dump) {
            super(to);
            this.fLog = dump;
        }

        @Override
        public void write(String s, int off, int len) {
            this.fLog.write(s, off, len);
            super.write(s, off, len);
        }

        @Override
        public void println() {
            this.fLog.println();
            super.println();
        }

        @Override
        public void close() {
            this.fLog.close();
            super.close();
        }

        @Override
        public void flush() {
            this.fLog.flush();
            super.flush();
        }
    }

    private class TracingOutputStream
    extends OutputStream {
        private final OutputStream fTo;
        private final PrintWriter fLog;
        private static final int kLineLength = 16;
        private StringBuilder fHexBytes = new StringBuilder();
        private StringBuilder fPrintableBytes = new StringBuilder();
        private int fPendingLength = 0;

        public TracingOutputStream(OutputStream to, PrintWriter dump) {
            this.fTo = to;
            this.fLog = dump;
        }

        @Override
        public void write(int b) throws IOException {
            this.out(b);
            this.fTo.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out(b, 0, b.length);
            this.fTo.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out(b, off, len);
            this.fTo.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.fTo.flush();
        }

        @Override
        public void close() throws IOException {
            this.fTo.close();
        }

        private void out(int b) {
            byte[] bs = new byte[]{(byte)b};
            this.out(bs, 0, 1);
        }

        private void out(byte[] bytes, int off, int len) {
            for (int i = off; i < off + len; ++i) {
                this.addByte(bytes[i]);
            }
        }

        private void addByte(byte b) {
            String hex = TypeConvertor.byteToHex((byte)b);
            this.fHexBytes.append(hex).append(' ');
            if (Character.isISOControl(b)) {
                this.fPrintableBytes.append(".");
            } else {
                this.fPrintableBytes.append((char)b);
            }
            ++this.fPendingLength;
            if (this.fPendingLength >= 16) {
                this.flushLog();
            }
        }

        public void flushLog() {
            if (this.fPendingLength > 0) {
                this.fLog.print(this.fHexBytes.toString());
                int lacking = 16 - this.fPendingLength;
                for (int i = 0; i < lacking; ++i) {
                    this.fLog.print("   ");
                }
                this.fLog.print("  ");
                this.fLog.println(this.fPrintableBytes.toString());
                this.fHexBytes = new StringBuilder();
                this.fPrintableBytes = new StringBuilder();
                this.fPendingLength = 0;
            }
        }
    }

    private class TracingInputStream
    extends InputStream {
        private final InputStream fTo;
        private final PrintWriter fLog;
        private static final int kLineLength = 16;
        private StringBuilder fHexBytes = new StringBuilder();
        private StringBuilder fPrintableBytes = new StringBuilder();
        private int fPendingLength = 0;

        public TracingInputStream(InputStream to, PrintWriter dump) {
            this.fTo = to;
            this.fLog = dump;
        }

        @Override
        public int read() throws IOException {
            int b = this.fTo.read();
            if (b > -1) {
                this.out(b);
            }
            return b;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int result = this.fTo.read(b);
            this.out(b, 0, result);
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.fTo.read(b, off, len);
            this.out(b, off, result);
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            this.out("skip " + n);
            return this.fTo.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.fTo.available();
        }

        @Override
        public void close() throws IOException {
            this.flushLog();
            this.fTo.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.out("mark(" + readlimit + ")");
            this.fTo.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.out("reset()");
            this.fTo.reset();
        }

        @Override
        public boolean markSupported() {
            return this.fTo.markSupported();
        }

        private void out(int b) {
            byte[] bs = new byte[]{(byte)b};
            this.out(bs, 0, 1);
        }

        private void out(byte[] bytes, int off, int len) {
            for (int i = off; i < off + len; ++i) {
                this.addByte(bytes[i]);
            }
        }

        private void out(String msg) {
            this.flushLog();
            this.fLog.println(msg);
        }

        private void addByte(byte b) {
            String hex = TypeConvertor.byteToHex((byte)b);
            this.fHexBytes.append(hex).append(' ');
            if (Character.isISOControl(b)) {
                this.fPrintableBytes.append(".");
            } else {
                this.fPrintableBytes.append((char)b);
            }
            ++this.fPendingLength;
            if (this.fPendingLength >= 16) {
                this.flushLog();
            }
        }

        public void flushLog() {
            if (this.fPendingLength > 0) {
                this.fLog.print(this.fHexBytes.toString());
                int lacking = 16 - this.fPendingLength;
                for (int i = 0; i < lacking; ++i) {
                    this.fLog.print("   ");
                }
                this.fLog.print("  ");
                this.fLog.println(this.fPrintableBytes.toString());
                this.fLog.flush();
                this.fHexBytes = new StringBuilder();
                this.fPrintableBytes = new StringBuilder();
                this.fPendingLength = 0;
            }
        }
    }

    private class TrxDumper
    implements CHttpObserver {
        private final PrintWriter fOut;
        private TracingInputStream fInStream;
        private TracingPrintWriter fPwStream;
        private TracingOutputStream fOutStream;
        private boolean fReplyStarted = false;

        TrxDumper(PrintWriter to) throws IOException {
            this.fOut = to;
            this.fOut.println();
            this.fOut.println("vvv");
            this.fOut.println("at: " + Clock.now());
        }

        @Override
        public CHttpObserver method(String method) {
            this.fOut.println("method: " + method);
            return this;
        }

        @Override
        public CHttpObserver onUrl(String url) {
            this.fOut.println("url: " + url);
            return this;
        }

        @Override
        public CHttpObserver queryString(String qs) {
            this.fOut.println("query: " + qs);
            return this;
        }

        @Override
        public CHttpObserver contentTypeRequest(String type) {
            this.fOut.println("contentType: " + type);
            return this;
        }

        @Override
        public CHttpObserver contentLengthRequest(int length) {
            this.fOut.println("contentLength: " + length);
            return this;
        }

        @Override
        public CHttpObserver withHeaders(CHttpObserver.HeaderLister hl) {
            Map<String, List<String>> headers = hl.getHeaders();
            LinkedList<String> keys = new LinkedList<String>();
            keys.addAll(headers.keySet());
            for (String key : keys) {
                List<String> values = headers.get(key);
                String val = values.size() == 1 ? values.get(0) : values.toString();
                this.fOut.println(key + ": " + val);
            }
            return this;
        }

        @Override
        public InputStream wrap(InputStream inputStream) {
            this.fInStream = new TracingInputStream(inputStream, this.fOut);
            return this.fInStream;
        }

        @Override
        public PrintWriter wrap(PrintWriter writer) {
            this.fPwStream = new TracingPrintWriter(writer, this.fOut);
            return this.fPwStream;
        }

        @Override
        public OutputStream wrap(OutputStream outputStream) {
            this.fOutStream = new TracingOutputStream(outputStream, this.fOut);
            return outputStream;
        }

        @Override
        public CHttpObserver replyWith(int status, String msg) {
            this.checkReplyStart();
            this.fOut.println("reply: " + status + " " + msg);
            return this;
        }

        @Override
        public CHttpObserver replyWith(int code) {
            this.checkReplyStart();
            this.fOut.println("reply: " + code);
            return this;
        }

        @Override
        public CHttpObserver replyHeader(String key, String value) {
            this.checkReplyStart();
            this.fOut.println("reply header: " + key + ": " + value);
            return this;
        }

        @Override
        public void closeTrx() {
            if (this.fInStream != null) {
                this.fInStream.flushLog();
            }
            if (this.fOutStream != null) {
                this.fOutStream.flushLog();
            }
            if (this.fPwStream != null) {
                this.fPwStream.flush();
            }
            this.fOut.println("^^^");
            this.fOut.close();
        }

        private void checkReplyStart() {
            if (!this.fReplyStarted) {
                this.fOut.println("");
                this.fOut.println("---");
                this.fOut.println("");
                this.fReplyStarted = true;
            }
        }
    }

    public static interface Filter {
        public String logName();

        public boolean matches(CHttpRequestContext var1);
    }
}

