/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.context;

import io.continual.http.service.framework.CHttpSession;
import io.continual.http.service.framework.context.CHttpRequest;
import io.continual.http.service.framework.context.CHttpResponse;
import io.continual.http.service.framework.inspection.CHttpObserver;
import io.continual.http.service.framework.inspection.impl.NoopInspector;
import io.continual.http.service.framework.routing.CHttpRequestRouter;

public abstract class CHttpRequestContext {
    private final CHttpSession fSession;
    private final CHttpRequestRouter fRouter;
    private CHttpObserver fInspector;

    public void install(CHttpObserver i) {
        this.fInspector = i == null ? new NoopInspector() : i;
    }

    public void close() {
        this.fInspector.closeTrx();
    }

    public CHttpSession session() {
        return this.fSession;
    }

    public abstract CHttpRequest request();

    public abstract CHttpResponse response();

    protected CHttpRequestRouter router() {
        return this.fRouter;
    }

    protected CHttpObserver inspector() {
        return this.fInspector;
    }

    protected CHttpRequestContext(CHttpSession s, CHttpRequestRouter router) {
        this.fSession = s;
        this.fRouter = router;
        this.fInspector = new NoopInspector();
    }
}

