/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.app.servers.endpoints;

import io.continual.builder.Builder;
import io.continual.http.app.servers.endpoints.TypicalUiEndpoint;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.sessions.CHttpUserSession;
import io.continual.iam.identity.Identity;
import io.continual.services.ServiceContainer;
import io.continual.templating.ContinualTemplateCatalog;
import io.continual.templating.ContinualTemplateContext;
import io.continual.templating.ContinualTemplateEngine;
import io.continual.templating.ContinualTemplateSource;
import java.io.IOException;
import org.json.JSONObject;

public class PageRenderer<I extends Identity>
extends TypicalUiEndpoint<I> {
    private final ContinualTemplateEngine fTemplates;
    private final ContinualTemplateCatalog fTemplateCatalog;
    private final String fPrefix;
    private final String fRequiredSuffix;

    public PageRenderer(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        this.fTemplates = (ContinualTemplateEngine)sc.getReqd("templateEngine", ContinualTemplateEngine.class);
        this.fTemplateCatalog = (ContinualTemplateCatalog)sc.getReqd("templateCatalog", ContinualTemplateCatalog.class);
        this.fPrefix = config.optString("prefix", null);
        this.fRequiredSuffix = config.optString("reqdSuffix", null);
    }

    public void getIndex(CHttpRequestContext context) throws ContinualTemplateSource.TemplateNotFoundException, IOException, ContinualTemplateEngine.TemplateParseException {
        this.getPage(context, "index.html");
    }

    public void getPage(CHttpRequestContext context, String path) throws ContinualTemplateSource.TemplateNotFoundException, IOException, ContinualTemplateEngine.TemplateParseException {
        ContinualTemplateContext templateCtx = this.fTemplates.createContext();
        CHttpUserSession.getSession(context).populateTemplateContext(templateCtx);
        this.updateContext(context, templateCtx, path);
        if (this.fPrefix != null) {
            path = this.fPrefix + path;
        }
        if (this.fRequiredSuffix != null && !path.endsWith(this.fRequiredSuffix)) {
            path = path + this.fRequiredSuffix;
        }
        ContinualTemplateSource template = this.fTemplateCatalog.getTemplate(new String[]{path});
        this.fTemplates.renderTemplate(template, templateCtx, context.response().getStreamForBinaryResponse("text/html"));
    }

    protected void updateContext(CHttpRequestContext context, ContinualTemplateContext templateCtx, String path) {
    }
}

