/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.app.servers.endpoints;

import io.continual.http.app.servers.endpoints.TypicalRestApiEndpoint;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.iam.IamAuthLog;
import io.continual.iam.IamService;
import io.continual.iam.credentials.ApiKeyCredential;
import io.continual.iam.credentials.JwtCredential;
import io.continual.iam.credentials.UsernamePasswordCredential;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.iam.impl.common.ApiKeyAuthHelper;
import io.continual.iam.impl.common.BasicAuthHelper;
import io.continual.iam.impl.common.HeaderReader;
import java.util.LinkedList;
import org.json.JSONObject;

class AuthList<I extends Identity>
implements TypicalRestApiEndpoint.Authenticator<I> {
    public static final String kSetting_ContinualProductTag = "apiKeyProductTag";
    public static final String kContinualProductTag = "continual";
    private final LinkedList<TypicalRestApiEndpoint.Authenticator<I>> fAuthenticators = new LinkedList();

    public AuthList(final JSONObject settings) {
        this.addAuthenticator(new TypicalRestApiEndpoint.Authenticator<I>(){

            @Override
            public I authenticate(IamService<I, ?> am, CHttpRequestContext context) throws IamSvcException {
                String systag = settings.optString(AuthList.kSetting_ContinualProductTag, AuthList.kContinualProductTag);
                Identity authUser = null;
                ApiKeyCredential creds = ApiKeyAuthHelper.readApiKeyCredential((JSONObject)settings, (HeaderReader)new CHttpHeaderReader(context), (String)systag);
                if (creds != null && (authUser = am.getIdentityDb().authenticate(creds)) != null) {
                    IamAuthLog.authenticationEvent((String)authUser.getId(), (String)"API Key", (String)context.request().getBestRemoteAddress());
                }
                return authUser;
            }
        });
        this.addAuthenticator(new TypicalRestApiEndpoint.Authenticator<I>(){

            @Override
            public I authenticate(IamService<I, ?> am, CHttpRequestContext context) throws IamSvcException {
                Identity authUser = null;
                try {
                    String queryParam;
                    String[] parts;
                    JwtCredential cred = null;
                    String authHeader = context.request().getFirstHeader("Authorization");
                    if (authHeader != null && authHeader.startsWith("Bearer ") && (parts = authHeader.split(" ")).length == 2) {
                        cred = JwtCredential.fromHeader((String)authHeader);
                    }
                    if (cred == null && (queryParam = context.request().getParameter("jwt", null)) != null) {
                        cred = new JwtCredential(queryParam);
                    }
                    if (cred != null && (authUser = am.getIdentityDb().authenticate(cred)) != null) {
                        IamAuthLog.authenticationEvent((String)authUser.getId(), (String)"JWT", (String)context.request().getBestRemoteAddress());
                    }
                }
                catch (JwtCredential.InvalidJwtToken invalidJwtToken) {
                    // empty catch block
                }
                return authUser;
            }
        });
        this.addAuthenticator(new TypicalRestApiEndpoint.Authenticator<I>(){

            @Override
            public I authenticate(IamService<I, ?> am, CHttpRequestContext context) throws IamSvcException {
                Identity authUser = null;
                UsernamePasswordCredential upc = BasicAuthHelper.readUsernamePasswordCredential((HeaderReader)new CHttpHeaderReader(context));
                if (upc != null && (authUser = am.getIdentityDb().authenticate(upc)) != null) {
                    IamAuthLog.authenticationEvent((String)authUser.getId(), (String)"Username/Password", (String)context.request().getBestRemoteAddress());
                }
                return authUser;
            }
        });
    }

    public synchronized AuthList<I> addAuthenticator(TypicalRestApiEndpoint.Authenticator<I> a) {
        this.fAuthenticators.add(a);
        return this;
    }

    @Override
    public synchronized I authenticate(IamService<I, ?> am, CHttpRequestContext context) throws IamSvcException {
        for (TypicalRestApiEndpoint.Authenticator authenticator : this.fAuthenticators) {
            I result = authenticator.authenticate(am, context);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static class CHttpHeaderReader
    implements HeaderReader {
        private final CHttpRequestContext fContext;

        public CHttpHeaderReader(CHttpRequestContext context) {
            this.fContext = context;
        }

        public String getFirstHeader(String header) {
            return this.fContext.request().getFirstHeader(header);
        }
    }
}

