/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.app.servers;

import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.routing.CHttpRouteInvocation;
import io.continual.http.service.framework.routing.CHttpRouteSource;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import java.util.Map;

public class CorsOptionsRouter
implements CHttpRouteSource {
    private static final String skAllowHeadersValue = "Content-Type, Authorization, X-Continual-Auth, X-Continual-Date, X-Continual-Magic";

    @Override
    public CHttpRouteInvocation getRouteFor(String verb, String path) {
        if (verb != null && verb.equalsIgnoreCase("OPTIONS")) {
            return new CHttpRouteInvocation(){

                @Override
                public void run(CHttpRequestContext context) {
                    CorsOptionsRouter.setupCorsHeaders(context);
                    context.response().setStatus(204);
                }

                @Override
                public Path getRouteNameForMetrics() {
                    return Path.getRootPath().makeChildItem(Name.fromString((String)"options"));
                }
            };
        }
        return null;
    }

    @Override
    public String getRouteTo(Class<?> c, String staticMethodName, Map<String, Object> args) {
        return null;
    }

    public static void setupCorsHeaders(CHttpRequestContext context) {
        context.response().writeHeader("Access-Control-Allow-Origin", "*").writeHeader("Access-Control-Allow-Methods", "DELETE, GET, OPTIONS, PATCH, POST, PUT").writeHeader("Access-Control-Max-Age", "3600").writeHeader("Access-Control-Allow-Headers", skAllowHeadersValue);
    }
}

