/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.app.htmlForms;

import io.continual.http.app.htmlForms.CHttpFormFieldInfo;
import io.continual.http.app.htmlForms.CHttpFormPostWrapper;
import io.continual.http.app.htmlForms.CHttpFormValidationStep;
import io.continual.http.app.htmlForms.CHttpInvalidFormException;
import io.continual.http.service.framework.context.CHttpRequestContext;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class CHttpFormValidator {
    private final HashMap<String, CHttpFormFieldInfo> fMap = new HashMap();
    private final LinkedList<CHttpFormValidationStep> fValidators = new LinkedList();

    public CHttpFormValidator() {
        this(null);
    }

    public CHttpFormValidator(CHttpFormValidator wrapped) {
        if (wrapped != null) {
            this.addValidation(new wrapper(wrapped));
        }
    }

    public void validate(CHttpRequestContext context, CHttpFormPostWrapper w) throws CHttpInvalidFormException {
        try {
            CHttpInvalidFormException ve = new CHttpInvalidFormException();
            for (CHttpFormFieldInfo fi : this.fMap.values()) {
                fi.validate(context, w, ve);
            }
            for (CHttpFormValidationStep step : this.fValidators) {
                step.validate(context, w, null, ve);
            }
            if (ve.size() > 0) {
                throw ve;
            }
        }
        catch (CHttpFormPostWrapper.ParseException e) {
            throw new CHttpInvalidFormException().addProblem(e.getMessage());
        }
    }

    public Map<String, CHttpFormFieldInfo> getFields() {
        return this.fMap;
    }

    public CHttpFormFieldInfo field(String name) {
        CHttpFormFieldInfo fi = this.fMap.get(name);
        if (fi == null) {
            fi = new CHttpFormFieldInfo(name);
            this.fMap.put(name, fi);
        }
        return fi;
    }

    public void addValidation(CHttpFormValidationStep step) {
        this.fValidators.add(step);
    }

    private class wrapper
    implements CHttpFormValidationStep {
        private CHttpFormValidator fWrapped;

        public wrapper(CHttpFormValidator step) {
            this.fWrapped = step;
        }

        @Override
        public void validate(CHttpRequestContext context, CHttpFormPostWrapper form, CHttpFormFieldInfo field, CHttpInvalidFormException err) {
            try {
                this.fWrapped.validate(context, form);
            }
            catch (CHttpInvalidFormException e) {
                err.addProblemsFrom(e);
            }
        }
    }
}

