/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.app.htmlForms;

import io.continual.http.app.htmlForms.CHttpFormPostWrapper;
import io.continual.http.app.htmlForms.CHttpFormValidationStep;
import io.continual.http.app.htmlForms.CHttpInvalidFormException;
import io.continual.http.service.framework.context.CHttpRequestContext;
import java.util.LinkedList;

public class CHttpFormFieldInfo {
    public final String fFieldName;
    private LinkedList<CHttpFormValidationStep> fSteps;

    public CHttpFormFieldInfo(String fn) {
        this.fFieldName = fn;
        this.fSteps = new LinkedList();
    }

    public void validate(CHttpRequestContext context, CHttpFormPostWrapper form, CHttpInvalidFormException err) throws CHttpFormPostWrapper.ParseException {
        for (CHttpFormValidationStep step : this.fSteps) {
            step.validate(context, form, this, err);
        }
    }

    public CHttpFormFieldInfo validateWith(CHttpFormValidationStep step) {
        this.fSteps.add(step);
        return this;
    }

    public CHttpFormFieldInfo required(final String errMsg) {
        return this.validateWith(new CHttpFormValidationStep(){

            @Override
            public void validate(CHttpRequestContext context, CHttpFormPostWrapper form, CHttpFormFieldInfo field, CHttpInvalidFormException err) throws CHttpFormPostWrapper.ParseException {
                if (!form.hasParameter(CHttpFormFieldInfo.this.fFieldName)) {
                    err.addProblem(CHttpFormFieldInfo.this.fFieldName, errMsg);
                } else {
                    String val = form.getValue(CHttpFormFieldInfo.this.fFieldName);
                    if (val != null && val.length() == 0) {
                        err.addProblem(CHttpFormFieldInfo.this.fFieldName, errMsg);
                    }
                }
            }
        });
    }

    public CHttpFormFieldInfo oneOf(String[] values, String errMsg) {
        return this.oneOf(values, true, errMsg);
    }

    public CHttpFormFieldInfo oneOf(final String[] values, final boolean caseSensitive, final String errMsg) {
        return this.validateWith(new CHttpFormValidationStep(){

            @Override
            public void validate(CHttpRequestContext context, CHttpFormPostWrapper form, CHttpFormFieldInfo field, CHttpInvalidFormException err) throws CHttpFormPostWrapper.ParseException {
                if (!form.hasParameter(CHttpFormFieldInfo.this.fFieldName)) {
                    err.addProblem(CHttpFormFieldInfo.this.fFieldName, errMsg);
                } else {
                    String val = form.getValue(CHttpFormFieldInfo.this.fFieldName);
                    boolean found = false;
                    for (String v : values) {
                        if ((!caseSensitive || !v.equals(val)) && (caseSensitive || !v.equalsIgnoreCase(val))) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        err.addProblem(CHttpFormFieldInfo.this.fFieldName, errMsg);
                    }
                }
            }
        });
    }

    public CHttpFormFieldInfo oneOf(Object[] values, String errMsg) {
        int current = 0;
        String[] stringVals = new String[values.length];
        for (Object o : values) {
            stringVals[current++] = o.toString();
        }
        return this.oneOf(stringVals, errMsg);
    }

    public CHttpFormFieldInfo matches(final String regex, final String errMsg) {
        return this.validateWith(new CHttpFormValidationStep(){

            @Override
            public void validate(CHttpRequestContext context, CHttpFormPostWrapper form, CHttpFormFieldInfo field, CHttpInvalidFormException err) throws CHttpFormPostWrapper.ParseException {
                String value = form.getValue(CHttpFormFieldInfo.this.fFieldName);
                if (value == null) {
                    value = "";
                }
                if (!value.matches(regex)) {
                    err.addProblem(CHttpFormFieldInfo.this.fFieldName, errMsg);
                }
            }
        });
    }

    public CHttpFormFieldInfo defaultValue(final String defVal) {
        return this.validateWith(new CHttpFormValidationStep(){

            @Override
            public void validate(CHttpRequestContext context, CHttpFormPostWrapper form, CHttpFormFieldInfo field, CHttpInvalidFormException err) throws CHttpFormPostWrapper.ParseException {
                if (!form.hasParameter(CHttpFormFieldInfo.this.fFieldName) || form.isFormField(CHttpFormFieldInfo.this.fFieldName) && form.getValue(CHttpFormFieldInfo.this.fFieldName).length() == 0) {
                    form.changeValue(CHttpFormFieldInfo.this.fFieldName, defVal);
                }
            }
        });
    }

    public CHttpFormFieldInfo defaultValue(Object o) {
        return this.defaultValue(o.toString());
    }

    public CHttpFormFieldInfo isBoolean(String errMsg) {
        return this.oneOf(new String[]{"true", "false", "yes", "no", "on", "off", "1", "0", "checked"}, false, errMsg);
    }
}

