/*
 * Decompiled with CFR 0.152.
 */
package io.continual.notify;

import io.continual.notify.ContinualNotifier;
import io.continual.util.time.Clock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinualAlertAgent {
    private final HashMap<String, HashMap<String, Alert>> fAlertsBySubjectAndCondition = new HashMap();
    private final ContinualNotifier fEventsOut;
    private static final Logger log = LoggerFactory.getLogger(ContinualAlertAgent.class);

    public ContinualAlertAgent() {
        this(new ContinualNotifier());
    }

    public ContinualAlertAgent(ContinualNotifier out) {
        this.fEventsOut = out;
    }

    public Alert onset(String subject, String condition) {
        return this.onset(subject, condition, Clock.now());
    }

    public Alert onset(String subject, String condition, Throwable x) {
        JSONObject addlData = new JSONObject();
        ContinualAlertAgent.populateExceptionInto(addlData, x);
        return this.onset(subject, condition, Clock.now(), addlData);
    }

    public Alert onset(String subject, String condition, long atMs) {
        return this.onset(subject, condition, atMs, new JSONObject());
    }

    public Alert onset(String subject, String condition, JSONObject addlData) {
        return this.onset(subject, condition, Clock.now(), addlData);
    }

    public static void populateExceptionInto(JSONObject addlData, Throwable t) {
        String stack = "??";
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             PrintStream ps = new PrintStream(baos);){
            t.printStackTrace(ps);
            ps.close();
            stack = new String(baos.toByteArray());
        }
        catch (IOException x) {
            stack = "?? IOException: " + x.getMessage();
        }
        addlData.put("class", (Object)t.getClass().getName()).put("message", (Object)t.getMessage()).put("stack", (Object)stack);
    }

    public Alert onset(String subject, String condition, long atMs, JSONObject addlData) {
        Alert alert;
        HashMap<String, Alert> byCondition = this.fAlertsBySubjectAndCondition.get(subject);
        if (byCondition == null) {
            byCondition = new HashMap();
            this.fAlertsBySubjectAndCondition.put(subject, byCondition);
        }
        if ((alert = byCondition.get(condition)) != null) {
            log.info("Alert for {}:{} already exists; ignored.", (Object)subject, (Object)condition);
        } else {
            alert = new IntAlert(subject, condition, atMs, addlData);
            this.fEventsOut.onSubject(alert.subject()).withCondition(alert.condition()).withAddlData("at", atMs).withAddlData("addl", addlData).asOnset().send();
            byCondition.put(condition, alert);
            log.info("Raised alert: " + alert.toString());
        }
        return alert;
    }

    public Alert get(String subject, String condition) {
        HashMap<String, Alert> byCondition = this.fAlertsBySubjectAndCondition.get(subject);
        if (byCondition == null) {
            return null;
        }
        return byCondition.get(condition);
    }

    public Alert clear(String subject, String condition) {
        Alert a = this.get(subject, condition);
        if (a != null) {
            a.clear();
        }
        return a;
    }

    public Collection<Alert> standingAlerts() {
        LinkedList<Alert> result = new LinkedList<Alert>();
        for (Map.Entry<String, HashMap<String, Alert>> e : this.fAlertsBySubjectAndCondition.entrySet()) {
            for (Alert a : e.getValue().values()) {
                result.add(a);
            }
        }
        return result;
    }

    private class IntAlert
    implements Alert {
        private final String fSubject;
        private final String fCondition;
        private final long fWhen;
        private final JSONObject fAddlData;

        public IntAlert(String subj, String cond, long when, JSONObject addlData) {
            this.fSubject = subj;
            this.fCondition = cond;
            this.fWhen = when;
            this.fAddlData = addlData == null ? new JSONObject() : addlData;
        }

        public String toString() {
            return new JSONObject().put("subject", (Object)this.subject()).put("condition", (Object)this.condition()).put("when", this.when()).put("addldata", (Object)this.fAddlData).toString();
        }

        @Override
        public String subject() {
            return this.fSubject;
        }

        @Override
        public String condition() {
            return this.fCondition;
        }

        @Override
        public long when() {
            return this.fWhen;
        }

        @Override
        public void clear(long clearTimeMs) {
            HashMap byCondition = (HashMap)ContinualAlertAgent.this.fAlertsBySubjectAndCondition.get(this.subject());
            Alert fromMap = (Alert)byCondition.remove(this.condition());
            if (fromMap != this) {
                log.warn("Lookup for clear of {} found a different instance.", (Object)this);
            } else {
                ContinualAlertAgent.this.fEventsOut.onSubject(this.subject()).withCondition(this.condition()).withAddlData("at", clearTimeMs).asClear().send();
            }
        }
    }

    public static interface Alert {
        public String subject();

        public String condition();

        public long when();

        default public void clear() {
            this.clear(Clock.now());
        }

        public void clear(long var1);
    }
}

