/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.standalone;

import io.continual.util.console.CmdLineParser;
import io.continual.util.console.CmdLinePrefs;
import io.continual.util.console.ConsoleProgram;
import io.continual.util.console.DaemonConsole;
import io.continual.util.nv.NvReadable;
import io.continual.util.nv.NvWriteable;
import java.io.File;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Tomcat;

public abstract class CHttpStandaloneServer
extends DaemonConsole {
    public static final String kSetting_Port = "port";
    public static final int kDefault_Port = 8080;
    public static final String kSetting_WebRoot = "webroot";
    private Tomcat fTomcat;
    private NvReadable fCommandLineSettings = null;
    private static final Logger log = Logger.getLogger(CHttpStandaloneServer.class.getName());

    protected CHttpStandaloneServer setupDefaults(NvWriteable pt) {
        pt.set(kSetting_WebRoot, ".");
        return this;
    }

    protected CHttpStandaloneServer setupOptions(CmdLineParser p) {
        super.setupOptions(p);
        p.registerOptionWithValue(kSetting_WebRoot);
        p.registerOptionWithValue(kSetting_Port, "p", null, null);
        return this;
    }

    protected ConsoleProgram.Looper init(NvReadable p, CmdLinePrefs clp) throws NvReadable.MissingReqdSettingException, NvReadable.InvalidSettingValueException, ConsoleProgram.StartupFailureException {
        this.fCommandLineSettings = p;
        ConsoleProgram.Looper result = super.init(p, clp);
        this.fTomcat = new Tomcat();
        int port = p.getInt(kSetting_Port, 8080);
        this.fTomcat.setPort(port);
        File base = new File(System.getProperty("java.io.tmpdir"));
        Context rootCtx = this.fTomcat.addContext("", base.getAbsolutePath());
        String servletName = this.getProgramName();
        Tomcat.addServlet((Context)rootCtx, (String)servletName, (Servlet)this.createServlet(p));
        rootCtx.addServletMappingDecoded("/*", servletName);
        try {
            this.fTomcat.start();
        }
        catch (LifecycleException e) {
            throw new ConsoleProgram.StartupFailureException((Exception)((Object)e));
        }
        log.info("Server listening on port " + port + ".");
        return result;
    }

    protected abstract Servlet createServlet(NvReadable var1);

    protected CHttpStandaloneServer(String programName) {
        super(programName);
    }

    protected NvReadable getCommandLineSettings() {
        return this.fCommandLineSettings;
    }

    protected boolean daemonStillRunning() {
        this.fTomcat.getServer().await();
        return false;
    }
}

