/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.context;

import io.continual.http.service.framework.context.CHttpRequest;
import io.continual.http.service.framework.context.ServletRequestTools;
import io.continual.http.service.framework.inspection.CHttpObserver;
import io.continual.http.service.framework.inspection.impl.NoopInspector;
import io.continual.util.data.TypeConvertor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

class StdRequest
implements CHttpRequest {
    private final HttpServletRequest fRequest;
    private final HashMap<String, String[]> fParamOverrides;
    private final CHttpObserver fInspector;

    public StdRequest(HttpServletRequest r) {
        this(r, (CHttpObserver)new NoopInspector());
    }

    public StdRequest(HttpServletRequest r, CHttpObserver inspector) {
        this.fRequest = r;
        this.fParamOverrides = new HashMap();
        this.fInspector = inspector;
        this.fInspector.method(this.getMethod()).onUrl(this.getUrl()).queryString(this.getQueryString()).withHeaders(() -> this.getAllHeaders());
    }

    public String getUrl() {
        return this.fRequest.getRequestURL().toString();
    }

    public boolean isSecure() {
        return this.fRequest.isSecure();
    }

    public String getQueryString() {
        String qs = this.fRequest.getQueryString();
        if (qs != null && qs.length() == 0) {
            return null;
        }
        return qs;
    }

    public String getMethod() {
        return this.fRequest.getMethod();
    }

    public String getPathInContext() {
        String ctxPath = this.fRequest.getContextPath();
        int ctxPathLen = ctxPath.length();
        return this.fRequest.getRequestURI().substring(ctxPathLen);
    }

    public String getFirstHeader(String h) {
        return ServletRequestTools.getFirstHeader(this.fRequest, h);
    }

    public List<String> getHeader(String h) {
        return ServletRequestTools.getHeader(this.fRequest, h);
    }

    public Map<String, List<String>> getAllHeaders() {
        return ServletRequestTools.getAllHeaders(this.fRequest);
    }

    public String getContentType() {
        String result = this.fRequest.getContentType();
        this.fInspector.contentTypeRequest(result);
        return result;
    }

    public int getContentLength() {
        int result = this.fRequest.getContentLength();
        this.fInspector.contentLengthRequest(result);
        return result;
    }

    public InputStream getBodyStream() throws IOException {
        return this.fInspector.wrap((InputStream)this.fRequest.getInputStream());
    }

    public BufferedReader getBodyStreamAsText() throws IOException {
        return new BufferedReader(new InputStreamReader(this.getBodyStream()));
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Map m = this.fRequest.getParameterMap();
        map.putAll(m);
        map.putAll(this.fParamOverrides);
        return map;
    }

    public String getParameter(String key) {
        if (this.fParamOverrides.containsKey(key)) {
            String[] o = this.fParamOverrides.get(key);
            return o.length > 0 ? o[0] : "";
        }
        return this.fRequest.getParameter(key);
    }

    public String getParameter(String key, String defVal) {
        String p = this.getParameter(key);
        if (p == null) {
            p = defVal;
        }
        return p;
    }

    public int getIntParameter(String key, int defVal) {
        int result = defVal;
        String p = this.getParameter(key);
        if (p != null) {
            try {
                result = TypeConvertor.convertToInt((String)p);
            }
            catch (Exception x) {
                result = defVal;
            }
        }
        return result;
    }

    public long getLongParameter(String key, long defVal) {
        long result = defVal;
        String p = this.getParameter(key);
        if (p != null) {
            try {
                result = TypeConvertor.convertToLong((String)p);
            }
            catch (Exception x) {
                result = defVal;
            }
        }
        return result;
    }

    public double getDoubleParameter(String key, double defVal) {
        double result = defVal;
        String p = this.getParameter(key);
        if (p != null) {
            try {
                result = TypeConvertor.convertToDouble((String)p);
            }
            catch (Exception x) {
                result = defVal;
            }
        }
        return result;
    }

    public boolean getBooleanParameter(String key, boolean defVal) {
        boolean result = defVal;
        String p = this.getParameter(key);
        if (p != null) {
            try {
                result = TypeConvertor.convertToBooleanBroad((String)p);
            }
            catch (Exception x) {
                result = defVal;
            }
        }
        return result;
    }

    public char getCharParameter(String key, char defVal) {
        char result = defVal;
        String p = this.getParameter(key);
        if (p != null && p.length() == 1) {
            result = p.charAt(0);
        }
        return result;
    }

    public void changeParameter(String fieldName, String value) {
        this.fParamOverrides.put(fieldName, new String[]{value});
    }

    public String getActualRemoteAddress() {
        return ServletRequestTools.getActualRemoteAddress(this.fRequest);
    }

    public String getBestRemoteAddress() {
        return ServletRequestTools.getBestRemoteAddress(this.fRequest);
    }

    public int getActualRemotePort() {
        return this.fRequest.getRemotePort();
    }

    public int getBestRemotePort() {
        return ServletRequestTools.getBestRemotePort(this.fRequest);
    }
}

