/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.context;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ServletRequestTools {
    public static String getActualRemoteAddress(HttpServletRequest req) {
        return req.getRemoteAddr();
    }

    public static int getActualRemotePort(HttpServletRequest req) {
        return req.getRemotePort();
    }

    public static String getBestRemoteAddress(HttpServletRequest req) {
        String fwdHost = ServletRequestTools.getFirstHeader(req, "X-Forwarded-For");
        return fwdHost != null ? fwdHost : ServletRequestTools.getActualRemoteAddress(req);
    }

    public static int getBestRemotePort(HttpServletRequest req) {
        String fwdPort = ServletRequestTools.getFirstHeader(req, "X-Forwarded-Port");
        if (fwdPort != null) {
            return Integer.parseInt(fwdPort);
        }
        return ServletRequestTools.getActualRemotePort(req);
    }

    public static String getFirstHeader(HttpServletRequest req, String h) {
        List<String> l = ServletRequestTools.getHeader(req, h);
        return l.size() > 0 ? l.iterator().next() : null;
    }

    public static List<String> getHeader(HttpServletRequest req, String h) {
        LinkedList<String> list = new LinkedList<String>();
        Enumeration e = req.getHeaders(h);
        while (e.hasMoreElements()) {
            list.add(e.nextElement().toString());
        }
        return list;
    }

    public static Map<String, List<String>> getAllHeaders(HttpServletRequest req) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        Enumeration names = req.getHeaderNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String headerName = names.nextElement().toString();
                LinkedList<String> list = new LinkedList<String>();
                result.put(headerName, list);
                Enumeration values = req.getHeaders(headerName);
                if (values == null) continue;
                while (values.hasMoreElements()) {
                    list.add(values.nextElement().toString());
                }
            }
        }
        return result;
    }
}

