/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework;

import io.continual.builder.Builder;
import io.continual.http.service.framework.CHttpErrorHandler;
import io.continual.http.service.framework.CHttpFilter;
import io.continual.http.service.framework.CHttpMetricNamer;
import io.continual.http.service.framework.CHttpRouteInstaller;
import io.continual.http.service.framework.CHttpServletSettings;
import io.continual.http.service.framework.CHttpSession;
import io.continual.http.service.framework.context.CHttpRequest;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.context.ServletRequestContext;
import io.continual.http.service.framework.context.ServletRequestTools;
import io.continual.http.service.framework.inspection.CHttpObserverMgr;
import io.continual.http.service.framework.inspection.impl.ObserveNoneMgr;
import io.continual.http.service.framework.routing.CHttpRequestRouter;
import io.continual.http.service.framework.routing.CHttpRouteInvocation;
import io.continual.http.service.framework.sessions.CHttpUserSession;
import io.continual.iam.IamService;
import io.continual.metrics.MetricsCatalog;
import io.continual.metrics.metricTypes.Timer;
import io.continual.util.data.HumanReadableHelper;
import io.continual.util.legal.CopyrightGenerator;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import io.continual.util.nv.NvReadable;
import io.continual.util.nv.impl.nvInstallTypeWrapper;
import io.continual.util.nv.impl.nvJsonObject;
import io.continual.util.nv.impl.nvReadableStack;
import io.continual.util.time.Clock;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHttpServlet
extends HttpServlet {
    private static final String kSetting_SessionTimeout = "sessionDuration";
    private static final String kDefault_SessionTimeout = "14d";
    private NvReadable fSettings;
    private final JSONObject fProvidedPrefs;
    private final SessionLifeCycle fSessionLifeCycle;
    private final int fSessionTimeInSeconds;
    private final LinkedList<CHttpRouteInstaller> fRouters;
    private final LinkedList<CHttpFilter> fFilters;
    private CHttpRequestRouter fRouter;
    private final IamService<?, ?> fAccounts;
    private final MetricsCatalog fMetrics;
    private final CHttpObserverMgr fInspector;
    private static final String kWebSessionObject = "chttp.session.";
    private static final long serialVersionUID = 1L;
    private final CHttpMetricNamer fMetricNamer;
    private static Logger log = LoggerFactory.getLogger(CHttpServlet.class);

    public CHttpServlet() throws Builder.BuildFailure {
        this(SessionLifeCycle.NO_SESSION);
    }

    public CHttpServlet(SessionLifeCycle slc) throws Builder.BuildFailure {
        this(new JSONObject(), slc, null, null, null);
    }

    public CHttpServlet(JSONObject settings, SessionLifeCycle slc, MetricsCatalog metrics, CHttpObserverMgr inspector, IamService<?, ?> accounts) throws Builder.BuildFailure {
        this.fProvidedPrefs = settings;
        this.fRouter = null;
        this.fMetrics = metrics;
        this.fInspector = inspector != null ? inspector : new ObserveNoneMgr();
        this.fRouters = new LinkedList();
        this.fFilters = new LinkedList();
        JSONObject namer = settings != null ? settings.optJSONObject("metricsNamer") : null;
        this.fMetricNamer = namer != null ? (CHttpMetricNamer)Builder.withBaseClass(CHttpMetricNamer.class).withClassNameInData().usingData(namer).build() : null;
        this.fAccounts = accounts;
        this.fSessionLifeCycle = slc;
        int sessionDuration = (int)HumanReadableHelper.parseDuration((String)settings.optString(kSetting_SessionTimeout, kDefault_SessionTimeout));
        if (sessionDuration < 0 || sessionDuration > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid time specification.");
        }
        this.fSessionTimeInSeconds = sessionDuration * 1000;
    }

    public final void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        for (String msg : CopyrightGenerator.getStandardNotice().getCopyrightNotices()) {
            log.info(msg);
        }
        nvReadableStack settingsStack = new nvReadableStack();
        settingsStack.push((NvReadable)new CHttpServletSettings(sc));
        if (this.fProvidedPrefs != null) {
            settingsStack.push((NvReadable)new nvJsonObject(this.fProvidedPrefs));
        }
        NvReadable appLevelSettings = this.makeSettings((NvReadable)settingsStack);
        this.fSettings = new nvInstallTypeWrapper(appLevelSettings);
        this.fRouter = new CHttpRequestRouter();
        try {
            log.info("Calling app servlet setup.");
            this.servletSetup();
        }
        catch (NvReadable.InvalidSettingValueException | NvReadable.MissingReqdSettingException e) {
            log.error("Shutting down due to missing setting. " + e.getMessage());
            throw new ServletException(e);
        }
        log.info("Servlet is ready.");
    }

    public final void destroy() {
        super.destroy();
        try {
            this.servletShutdown();
        }
        catch (Exception x) {
            log.error("During tear-down: " + x.getMessage());
        }
    }

    public CHttpServlet addRouter(CHttpRouteInstaller value) {
        this.fRouters.add(value);
        return this;
    }

    public CHttpServlet addFilter(CHttpFilter value) {
        this.fFilters.add(value);
        return this;
    }

    @Deprecated
    public NvReadable getSettings() {
        return this.fSettings;
    }

    public CHttpUserSession createSession() throws NvReadable.MissingReqdSettingException {
        return new CHttpUserSession(this.fAccounts);
    }

    public CHttpRequestRouter getRequestRouter() {
        return this.fRouter;
    }

    public IamService<?, ?> getAccounts() {
        return this.fAccounts;
    }

    protected NvReadable makeSettings(NvReadable fromBase) {
        return fromBase;
    }

    protected void servletSetup() throws NvReadable.MissingReqdSettingException, NvReadable.InvalidSettingValueException, ServletException {
        try {
            NvReadable p = this.getSettings();
            CHttpRequestRouter rr = this.getRequestRouter();
            for (CHttpRouteInstaller router : this.fRouters) {
                router.setupRouter(rr, p);
            }
            log.info("The server is ready.");
        }
        catch (Builder.BuildFailure | IOException e) {
            throw new ServletException(e);
        }
    }

    protected void servletShutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Path pathAsMetricName;
        ServletRequestContext ctx;
        String reqId;
        long startMs;
        block17: {
            startMs = Clock.now();
            String clientIp = ServletRequestTools.getBestRemoteAddress(req);
            reqId = clientIp + " " + req.getMethod() + " " + req.getRequestURI();
            log.debug("start " + reqId);
            CHttpSession session = this.getSession(req);
            ctx = this.createHandlingContext(req, resp, session, this.fRouter);
            this.fInspector.consider((CHttpRequestContext)ctx);
            CHttpRequest reqObj = ctx.request();
            pathAsMetricName = this.getMetricNamer().getMetricNameFor(reqObj);
            try {
                CHttpFilter.Disposition preRouteOk;
                Timer.Context prt = this.fMetrics == null ? null : this.fMetrics.timer(pathAsMetricName.makeChildItem(Name.fromString((String)"executionTime"))).time();
                try {
                    preRouteOk = this.preRouteHandling(ctx);
                }
                finally {
                    if (prt != null) {
                        prt.stop();
                    }
                }
                if (preRouteOk != CHttpFilter.Disposition.PASS) break block17;
                CHttpRouteInvocation handler = this.fRouter.route(reqObj);
                pathAsMetricName = handler.getRouteNameForMetrics();
                Timer.Context timer = this.fMetrics == null ? null : this.fMetrics.timer(pathAsMetricName.makeChildItem(Name.fromString((String)"executionTime"))).time();
                try {
                    handler.run((CHttpRequestContext)ctx);
                }
                finally {
                    if (timer != null) {
                        timer.stop();
                    }
                }
            }
            catch (CHttpRequestRouter.noMatchingRoute e) {
                this.onError(ctx, e, new CHttpErrorHandler(){

                    public void handle(CHttpRequestContext ctx, Throwable cause) {
                        CHttpServlet.this.sendStdJsonError(ctx, 404, "Not found.");
                    }
                });
                pathAsMetricName = null;
                if (this.fMetrics != null) {
                    this.fMetrics.meter(Path.fromString((String)"/noMatchForMethodAndPath")).mark();
                }
            }
            catch (InvocationTargetException x) {
                Throwable t = x.getCause();
                if (t != null) {
                    this.onError(ctx, t, null);
                } else {
                    this.onError(ctx, x, null);
                }
            }
            catch (Throwable t) {
                this.onError(ctx, t, null);
            }
        }
        long endMs = Clock.now();
        long durationMs = endMs - startMs;
        int returnedStatusCode = ctx.response().getStatusCode();
        log.info("{} {} {} ms", new Object[]{reqId, returnedStatusCode, durationMs});
        ctx.close();
        if (this.fMetrics != null && pathAsMetricName != null) {
            this.fMetrics.meter(pathAsMetricName.makeChildItem(Name.fromString((String)"statusCode")).makeChildItem(Name.fromString((String)("" + returnedStatusCode)))).mark();
        }
    }

    protected CHttpFilter.Disposition preRouteHandling(ServletRequestContext ctx) {
        for (CHttpFilter filter : this.fFilters) {
            CHttpFilter.Disposition disp = filter.runFilter((CHttpRequestContext)ctx);
            if (disp != CHttpFilter.Disposition.RESPONDED) continue;
            return disp;
        }
        return CHttpFilter.Disposition.PASS;
    }

    protected ServletRequestContext createHandlingContext(HttpServletRequest req, HttpServletResponse resp, CHttpSession dc, CHttpRequestRouter rr) {
        return new ServletRequestContext(req, resp, dc, rr);
    }

    private void sendStdJsonError(CHttpRequestContext ctx, int err, String msg) {
        ctx.response().sendStatusAndBody(err, new JSONObject().put("statusCode", err).put("status", (Object)msg).toString(4), "application/json");
    }

    private void onError(CHttpRequestContext ctx, Throwable t, CHttpErrorHandler defHandler) {
        CHttpErrorHandler eh = this.fRouter.route(t);
        if (eh == null && defHandler != null) {
            eh = defHandler;
        }
        if (eh != null) {
            try {
                eh.handle(ctx, t);
            }
            catch (Throwable tt) {
                log.warn("Error handler failed, handling a " + t.getClass().getName() + ", with " + tt.getMessage());
                this.sendStdJsonError(ctx, 500, t.getMessage());
            }
        } else {
            log.warn("No handler defined for " + t.getClass().getName() + ". Sending 500.");
            this.sendStdJsonError(ctx, 500, t.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            log.warn(sw.toString());
        }
    }

    private String getSessionIdFromCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie c : req.getCookies()) {
                if (!c.getName().equals("JSESSIONID")) continue;
                return c.getValue();
            }
        }
        return null;
    }

    private CHttpSession getSession(HttpServletRequest req) throws ServletException {
        CHttpSession result = null;
        if (!this.fSessionLifeCycle.equals((Object)SessionLifeCycle.NO_SESSION)) {
            try {
                String servletSessionName = CHttpServlet.getSessionObjectName(((Object)((Object)this)).getClass());
                String sessionCookieWas = this.getSessionIdFromCookie(req);
                log.debug("Session ID from request cookie: " + sessionCookieWas);
                HttpSession session = req.getSession(true);
                log.debug("Session ID on response session: " + session.getId());
                result = (CHttpSession)session.getAttribute(servletSessionName);
                if (result == null && (result = this.createSession()) != null) {
                    session.setAttribute(servletSessionName, (Object)result);
                    session.setMaxInactiveInterval(this.fSessionTimeInSeconds);
                }
            }
            catch (NvReadable.MissingReqdSettingException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return result;
    }

    private static String getSessionObjectName(Class<?> c) {
        return kWebSessionObject + c.getName();
    }

    protected CHttpMetricNamer getMetricNamer() {
        if (this.fMetricNamer != null) {
            return this.fMetricNamer;
        }
        return new CHttpMetricNamer(){

            public Path getMetricNameFor(CHttpRequest req) {
                if (req == null) {
                    return Path.fromString((String)"/null");
                }
                String urlPathPart = req.getPathInContext();
                if ((urlPathPart = urlPathPart.replaceAll("\\.", "%2E")).equals(Path.getPathSeparatorString())) {
                    urlPathPart = "(root)";
                } else if (urlPathPart.endsWith(Path.getPathSeparatorString())) {
                    urlPathPart = urlPathPart.substring(0, urlPathPart.length() - 1);
                }
                return Path.fromString((String)("/" + req.getMethod() + " " + urlPathPart));
            }
        };
    }

    public static enum SessionLifeCycle {
        NO_SESSION,
        FULL_SESSION;

    }
}

