/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.model;

import io.continual.services.processor.engine.library.filters.Any;
import io.continual.services.processor.engine.model.Filter;
import io.continual.services.processor.engine.model.Processor;
import java.util.ArrayList;
import java.util.List;

public class Rule {
    private final Filter fFilter;
    private final ArrayList<Processor> fThens;
    private final ArrayList<Processor> fElses;

    public static Builder newRule() {
        return new Builder();
    }

    public Filter getFilter() {
        return this.fFilter;
    }

    public List<Processor> getThenProcs() {
        return this.fThens;
    }

    public List<Processor> getElseProcs() {
        return this.fElses;
    }

    private Rule(Builder b) {
        this.fFilter = b.fFilter;
        this.fThens = new ArrayList();
        this.fThens.addAll(b.fThens);
        this.fElses = new ArrayList();
        this.fElses.addAll(b.fElses);
    }

    public static class Builder {
        private Filter fFilter = new Any();
        private ArrayList<Processor> fThens = new ArrayList();
        private ArrayList<Processor> fElses = new ArrayList();
        private ArrayList<Processor> fActiveChain = null;

        public Builder checkIf(Filter f) {
            this.fFilter = f;
            return this;
        }

        public Builder alwaysDo(Processor p) {
            return this.checkIf(new Any()).thenDo(p);
        }

        public Builder thenDo(Processor p) {
            this.fActiveChain = this.fThens;
            return this.and(p);
        }

        public Builder thenDo(List<? extends Processor> pp) {
            this.fActiveChain = this.fThens;
            for (Processor processor : pp) {
                this.and(processor);
            }
            return this;
        }

        public Builder elseDo(Processor p) {
            this.fActiveChain = this.fElses;
            return this.and(p);
        }

        public Builder elseDo(List<? extends Processor> pp) {
            this.fActiveChain = this.fElses;
            for (Processor processor : pp) {
                this.and(processor);
            }
            return this;
        }

        public Builder and(Processor p) {
            if (this.fActiveChain == null) {
                throw new IllegalStateException("Can't add a processor without thenDo() or elseDo()");
            }
            this.fActiveChain.add(p);
            return this;
        }

        public Rule build() {
            return new Rule(this);
        }
    }
}

