/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.sources;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.library.sources.QueuingSource;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageAndRouting;
import io.continual.util.time.Clock;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageGenerator
extends QueuingSource {
    private final JSONObject fMessage;
    private final long fPauseMs;
    private long fNextMs;
    private long fSerialNumber = 0L;

    public MessageGenerator(JSONObject config) throws Builder.BuildFailure {
        this(null, config);
    }

    public MessageGenerator(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        super(config);
        try {
            JSONObject given = config.optJSONObject("message");
            this.fMessage = given == null ? new JSONObject() : given;
            this.fPauseMs = config.optLong("everyMs", 1000L);
            this.fNextMs = Clock.now() + this.fPauseMs;
        }
        catch (JSONException e) {
            throw new Builder.BuildFailure((Throwable)e);
        }
    }

    @Override
    protected List<MessageAndRouting> reload() {
        ArrayList<MessageAndRouting> result = new ArrayList<MessageAndRouting>();
        if (Clock.now() >= this.fNextMs) {
            this.fNextMs += this.fPauseMs;
            result.add(this.makeDefRoutingMessage(Message.copyJsonToMessage(this.fMessage.put("serialNumber", ++this.fSerialNumber))));
        }
        if (this.fPauseMs == 0L) {
            this.noteEndOfStream();
            this.fNextMs = Long.MAX_VALUE;
        }
        return result;
    }
}

