/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.sinks;

import io.continual.builder.Builder;
import io.continual.jsonHttpClient.HttpUsernamePasswordCredentials;
import io.continual.jsonHttpClient.JsonOverHttpClient;
import io.continual.jsonHttpClient.impl.ok.OkHttp;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Sink;
import io.continual.services.processor.engine.model.StreamProcessingContext;
import io.continual.util.time.Clock;
import java.io.IOException;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RcvrSink
implements Sink {
    private final String fHost;
    private final String fTopic;
    private final String fStream;
    private final HttpUsernamePasswordCredentials fCreds;
    private final int fMaxCacheLength;
    private final long fMaxCacheAgeMs;
    private final BackoffAlgo fBackoffAlgo;
    private final JsonOverHttpClient fClient;
    private final LinkedList<Packet> fPendingSends;
    private static final Logger log = LoggerFactory.getLogger(RcvrSink.class);

    @Override
    public void init() {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() {
        this.flush(null);
    }

    @Override
    public synchronized void process(MessageProcessingContext context) {
        String topic;
        StringBuilder path = new StringBuilder().append("/events");
        if (this.fTopic != null && (topic = context.evalExpression(this.fTopic)) != null && topic.length() > 0) {
            String stream;
            path.append("/").append(topic);
            if (this.fStream != null && (stream = context.evalExpression(this.fStream)) != null && stream.length() > 0) {
                path.append("/").append(stream);
            }
        }
        String thisPath = path.toString();
        JSONObject msg = context.getMessage().toJson();
        if (this.fPendingSends.size() > 0 && this.fPendingSends.peekFirst().pathIsNot(thisPath)) {
            this.flush(context.getStreamProcessingContext());
        }
        this.fPendingSends.add(new Packet(thisPath, msg));
        if (this.fPendingSends.size() > this.fMaxCacheLength || this.fPendingSends.peekFirst().isOlderThan(this.fMaxCacheAgeMs)) {
            this.flush(context.getStreamProcessingContext());
        }
    }

    private RcvrSink(Builder b) {
        this.fHost = b.fHost;
        this.fTopic = b.fTopic;
        this.fStream = b.fStream;
        this.fCreds = b.fCreds;
        this.fMaxCacheLength = b.fMaxCacheLength;
        this.fMaxCacheAgeMs = b.fMaxCacheAgeMs;
        this.fBackoffAlgo = b.fBackoffAlgo;
        this.fClient = new OkHttp();
        this.fPendingSends = new LinkedList();
    }

    private void warn(StreamProcessingContext spc, String msg) {
        if (spc != null) {
            spc.warn(msg);
        } else {
            log.warn(msg);
        }
    }

    private synchronized void flush(StreamProcessingContext spc) {
        if (this.fPendingSends.size() == 0) {
            return;
        }
        String path = this.fHost + this.fPendingSends.peekFirst().fPath;
        JSONArray body = new JSONArray();
        for (Packet p : this.fPendingSends) {
            body.put((Object)p.fMsg);
        }
        this.fPendingSends.clear();
        try {
            boolean sentOk = false;
            int thisAttempt = 1;
            int maxAttempts = 3;
            long waitMs = 0L;
            boolean badRequest = false;
            while (!sentOk && !badRequest && thisAttempt <= 3) {
                if (thisAttempt++ > 1 && (waitMs = this.fBackoffAlgo.getNextWait(thisAttempt, waitMs)) > 0L) {
                    Thread.sleep(waitMs);
                }
                JsonOverHttpClient.HttpRequest req = this.fClient.newRequest().onPath(path);
                if (this.fCreds != null) {
                    req.asUser(this.fCreds);
                }
                try {
                    JsonOverHttpClient.HttpResponse response = req.post(body);
                    Throwable throwable = null;
                    try {
                        sentOk = response.isSuccess();
                        if (sentOk) continue;
                        this.warn(spc, "Error posting to " + path + ": " + response.getCode() + " " + response.getMessage() + "; " + response.getBody().toString());
                        badRequest = response.isClientError();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (response == null) continue;
                        if (throwable != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        response.close();
                    }
                }
                catch (JsonOverHttpClient.HttpServiceException e) {
                    this.warn(spc, "Error posting to " + path + ": " + e.getMessage());
                }
                catch (JsonOverHttpClient.BodyFormatException x) {
                    this.warn(spc, "Response format was flawed from " + path + ": " + x.getMessage());
                }
            }
            if (!sentOk) {
                if (badRequest) {
                    this.warn(spc, "Post of " + body.length() + " messages resulted in bad request. MESSAGES DROPPED.");
                } else {
                    this.warn(spc, "Failed to post " + body.length() + " messages after " + (thisAttempt - 1) + " attempts. MESSAGES DROPPED.");
                }
            }
        }
        catch (InterruptedException x) {
            this.warn(spc, "Interrupted while waiting to send " + body.length() + " messages. MESSAGES DROPPED.");
        }
    }

    private static class Packet {
        public final String fPath;
        public final JSONObject fMsg;
        public final long fQueueTimeMs;

        public Packet(String path, JSONObject msg) {
            this.fPath = path;
            this.fMsg = msg;
            this.fQueueTimeMs = Clock.now();
        }

        public boolean pathIsNot(String otherPath) {
            return !this.fPath.equals(otherPath);
        }

        public boolean isOlderThan(long durationMs) {
            long ageMs = Clock.now() - this.fQueueTimeMs;
            return ageMs > durationMs;
        }
    }

    public static class Builder {
        private String fHost = "https://rcvr.continual.io";
        private String fTopic = null;
        private String fStream = null;
        private HttpUsernamePasswordCredentials fCreds = null;
        private int fMaxCacheLength = 0;
        private long fMaxCacheAgeMs = 0L;
        private BackoffAlgo fBackoffAlgo = new BackoffAlgo(){

            @Override
            public long getNextWait(int attemptNumber, long lastValue) {
                return 5000L;
            }
        };

        public Builder sendingTo(String host) {
            if (host != null && host.length() > 0) {
                if (!host.contains("://")) {
                    host = "http://" + host;
                }
                this.fHost = host;
            }
            return this;
        }

        public Builder onTopic(String topic) {
            this.fTopic = topic;
            return this;
        }

        public Builder onStream(String stream) {
            this.fStream = stream;
            return this;
        }

        public Builder asUser(String user, String pwd) {
            this.fCreds = user != null && user.length() > 0 ? new HttpUsernamePasswordCredentials(user, pwd) : null;
            return this;
        }

        public Builder maxCacheLength(int cacheLength) {
            this.fMaxCacheLength = Math.max(0, cacheLength);
            return this;
        }

        public Builder maxCacheAge(long cacheAgeMs) {
            this.fMaxCacheAgeMs = Math.max(0L, cacheAgeMs);
            return this;
        }

        public Builder backingOff(BackoffAlgo ba) {
            if (ba != null) {
                this.fBackoffAlgo = ba;
            }
            return this;
        }

        public RcvrSink build() throws Builder.BuildFailure {
            if (this.fStream != null && this.fTopic == null) {
                throw new Builder.BuildFailure("You may not set a stream without setting a topic.");
            }
            return new RcvrSink(this);
        }
    }

    public static interface BackoffAlgo {
        public long getNextWait(int var1, long var2);
    }
}

