/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.processors;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log
implements Processor {
    private final Logger fLog;
    private final String fFormat;
    private final String fEval;

    public Log(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        this(config.optString("logName", ""), config.optString("format", "{}"), config.optString("expression", null));
    }

    public Log() throws Builder.BuildFailure {
        this("");
    }

    public Log(String logName) throws Builder.BuildFailure {
        this(logName, "{}");
    }

    public Log(String logName, String format) throws Builder.BuildFailure {
        this(logName, format, null);
    }

    public Log(String logName, String format, String eval) throws Builder.BuildFailure {
        this.fLog = LoggerFactory.getLogger((String)logName);
        this.fFormat = format;
        this.fEval = eval;
    }

    @Override
    public void process(MessageProcessingContext context) {
        String line;
        String string = line = this.fEval == null ? context.getMessage().toLine() : context.evalExpression(this.fEval);
        if (this.fFormat != null) {
            this.fLog.info(this.fFormat, (Object)line);
        } else {
            this.fLog.info(line);
        }
    }
}

