/*
 * Decompiled with CFR 0.152.
 */
package io.continual.jsonHttpClient.impl.ok;

import io.continual.jsonHttpClient.JsonOverHttpClient;
import io.continual.jsonHttpClient.impl.ok.OkRequest;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttp
implements JsonOverHttpClient {
    private final Proxy fProxy;
    private OkHttpClient fHttpClient;
    private boolean fIgnoreCertValidation;
    private static final Logger log = LoggerFactory.getLogger(OkHttp.class);

    public OkHttp() {
        this(null, false);
    }

    public OkHttp(Proxy proxy) {
        this(proxy, false);
    }

    public OkHttp(Proxy proxy, boolean ignoreCertValidation) {
        this.fProxy = proxy;
        this.fIgnoreCertValidation = ignoreCertValidation;
    }

    @Override
    public JsonOverHttpClient.HttpRequest newRequest() {
        return new OkRequest(this.getHttpClient());
    }

    private OkHttpClient getHttpClient() {
        if (this.fHttpClient == null) {
            try {
                OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).proxy(this.fProxy);
                if (this.fIgnoreCertValidation) {
                    TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public void checkClientTrusted(X509Certificate[] chain, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] chain, String authType) {
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    }};
                    SSLContext sslContext = SSLContext.getInstance("SSL");
                    sslContext.init(null, trustAllCerts, new SecureRandom());
                    builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustAllCerts[0]);
                    builder.hostnameVerifier((hostname, session) -> true);
                }
                this.fHttpClient = builder.build();
            }
            catch (KeyManagementException | NoSuchAlgorithmException x) {
                log.warn("Couldn't ignore cert validation: " + x.getMessage());
            }
        }
        return this.fHttpClient;
    }
}

