/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.rcvr;

import io.continual.builder.Builder;
import io.continual.http.service.framework.routing.CHttpRequestRouter;
import io.continual.http.service.framework.routing.CHttpRouteSource;
import io.continual.http.service.framework.routing.playish.CHttpPlayishInstanceCallRoutingSource;
import io.continual.iam.identity.Identity;
import io.continual.resources.ResourceLoader;
import io.continual.restHttp.BaseApiServiceRouter;
import io.continual.restHttp.HttpRouter;
import io.continual.restHttp.HttpService;
import io.continual.restHttp.HttpServlet;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.services.rcvr.ReceiverApi;
import io.continual.util.nv.NvReadable;
import java.io.IOException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiverApiService<I extends Identity>
extends SimpleService {
    private static final Logger log = LoggerFactory.getLogger(ReceiverApiService.class);

    public ReceiverApiService(final ServiceContainer sc, final JSONObject config) throws Builder.BuildFailure {
        HttpService server = (HttpService)sc.get(config.optString("httpService", "httpService"), HttpService.class);
        server.addRouter("rcvrApi", (HttpRouter)new BaseApiServiceRouter(){

            public void setupRouter(HttpServlet servlet, CHttpRequestRouter rr, NvReadable p) throws IOException, Builder.BuildFailure {
                super.setupExceptionHandlers(servlet, rr, p);
                for (String routeFile : new String[]{"rcvrRoutes.conf"}) {
                    log.debug("Loading routes from " + routeFile);
                    rr.addRouteSource((CHttpRouteSource)new CHttpPlayishInstanceCallRoutingSource(new ReceiverApi(sc, config), ResourceLoader.load((String)routeFile)));
                }
            }
        });
    }
}

