/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.routing.playish;

import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.routing.playish.CHttpPlayishRouteHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceEntryAction<T>
implements CHttpPlayishRouteHandler {
    private final T fInstance;
    private String fAction;
    private final List<String> fArgs;
    private Method fMethod;
    private static final Logger log = LoggerFactory.getLogger(InstanceEntryAction.class);

    public InstanceEntryAction(T instance, String action, List<String> args, Collection<String> packages) {
        this.fInstance = instance;
        this.fAction = action;
        this.fArgs = args;
        this.fMethod = null;
        this.processAction(packages);
    }

    public String toString() {
        return this.fAction;
    }

    @Override
    public void handle(CHttpRequestContext context, List<String> addlArgs) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] methodArgs = new Object[addlArgs.size() + 1];
        methodArgs[0] = context;
        int i = 1;
        for (String arg : addlArgs) {
            methodArgs[i++] = arg;
        }
        this.fMethod.invoke(this.fInstance, methodArgs);
    }

    @Override
    public boolean actionMatches(String fullPath) {
        return this.fAction.equals(fullPath);
    }

    private void processAction(Collection<String> packages) {
        int lastDot = this.fAction.lastIndexOf(".");
        if (lastDot < 0) {
            throw new IllegalArgumentException("The action string should have at least \"class.method\".");
        }
        String className = this.fAction.substring(0, lastDot);
        String methodName = this.fAction.substring(lastDot + 1);
        try {
            Class<?> c = this.locateClass(className, packages);
            this.fAction = c.getName() + "." + methodName;
            Class[] s = new Class[this.fArgs.size() + 1];
            s[0] = CHttpRequestContext.class;
            for (int i = 1; i <= this.fArgs.size(); ++i) {
                s[i] = String.class;
            }
            this.fMethod = c.getMethod(methodName, s);
            if (Modifier.isStatic(this.fMethod.getModifiers())) {
                throw new IllegalArgumentException(methodName + " is static.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Class<?> locateClass(String name, Collection<String> packages) throws ClassNotFoundException {
        Class<?> result = this.tryClass(name);
        if (result == null) {
            String pkg;
            Iterator<String> iterator = packages.iterator();
            while (iterator.hasNext() && (result = this.tryClass((pkg = iterator.next()) + "." + name)) == null) {
            }
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    private Class<?> tryClass(String name) {
        Class<?> result = null;
        try {
            result = Class.forName(name);
            log.debug("class [" + name + "] located");
        }
        catch (ClassNotFoundException e) {
            log.debug("class [" + name + "] not found");
        }
        return result;
    }
}

