/*
 * Decompiled with CFR 0.152.
 */
package io.continual.restHttp;

import io.continual.http.service.framework.CHttpConnection;
import io.continual.http.service.framework.CHttpConnectionContext;
import io.continual.http.service.framework.CHttpServlet;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.iam.IamService;
import io.continual.iam.credentials.UsernamePasswordCredential;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.iam.identity.UserContext;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUserSession
implements CHttpConnection {
    private final IamService<?, ?> fAccounts;
    private UserContext<?> fUser;
    private static final Logger log = LoggerFactory.getLogger(HttpUserSession.class);

    public static HttpUserSession getSession(CHttpRequestContext context) {
        CHttpConnection dc = context.session();
        if (dc instanceof HttpUserSession) {
            return (HttpUserSession)dc;
        }
        throw new IllegalArgumentException(dc == null ? "No user session established." : "User session is not an HttpUserSession");
    }

    public HttpUserSession(IamService<?, ?> accounts) {
        this.fAccounts = accounts;
        this.fUser = null;
    }

    public void onSessionCreate(CHttpServlet ws, CHttpConnectionContext dcc) throws ServletException {
        dcc.setInactiveExpiration(14L, TimeUnit.DAYS);
    }

    public void onSessionClose() {
    }

    public void noteActivity() {
    }

    public void buildTemplateContext(HashMap<String, Object> context) {
    }

    public void login(String username, String password) {
        if (this.isLoggedIn()) {
            this.logout();
        }
        try {
            Identity user;
            Identity identity = user = this.fAccounts != null ? this.fAccounts.getIdentityDb().authenticate(new UsernamePasswordCredential(username, password)) : null;
            if (user != null) {
                log.info("LOGIN_OK [" + user.getId() + "].");
                this.fUser = new UserContext.Builder().forUser(user).build();
            } else {
                log.info("LOGIN_FAIL [" + username + "]");
            }
        }
        catch (IamSvcException e) {
            log.warn("Couldn't login user [" + username + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public void logout() {
        if (this.fUser != null) {
            log.info("Logout [" + this.fUser.toString() + "].");
        }
        this.fUser = null;
    }

    public void replaceLoggedInUser(Identity user) {
        if (this.isLoggedIn()) {
            this.logout();
        }
        log.info("LOGIN_REPLACED [" + user.getId() + "].");
        this.fUser = new UserContext.Builder().forUser(user).build();
    }

    public boolean isLoggedIn() {
        return this.fUser != null;
    }

    public UserContext<?> getUser() {
        return this.fUser;
    }

    public ByteArrayInputStream serialize() {
        return new ByteArrayInputStream(new JSONObject().put("user", this.fUser != null ? this.fUser.toJson() : null).toString().getBytes());
    }

    public void deserialize(ByteArrayInputStream sessionData) {
        this.fUser = null;
    }
}

