/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.model;

import io.continual.services.processor.engine.model.Pipeline;
import io.continual.services.processor.engine.model.Sink;
import io.continual.services.processor.engine.model.Source;
import io.continual.services.processor.service.ProcessingService;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class Program {
    public static final String kDefaultPipeline = "default";
    private final HashMap<String, SourceInfo> fSources = new HashMap();
    private final HashMap<String, Sink> fSinks = new HashMap();
    private final HashMap<String, Pipeline> fPipelines = new HashMap();

    public static JSONObject config() {
        return new JSONObject();
    }

    public Program addSource(String name, Source src) {
        this.fSources.put(name, new SourceInfo(src));
        return this;
    }

    public Program addServiceToSource(String srcName, String svcName, ProcessingService service) {
        SourceInfo si = this.fSources.get(srcName);
        if (si == null) {
            throw new IllegalStateException("There's no source named " + srcName + " in this program.");
        }
        si.addService(svcName, service);
        return this;
    }

    public Map<String, Source> getSources() {
        HashMap<String, Source> map = new HashMap<String, Source>();
        for (Map.Entry<String, SourceInfo> entry : this.fSources.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getSource());
        }
        return map;
    }

    public Map<String, ProcessingService> getServicesFor(String srcName) {
        SourceInfo si = this.fSources.get(srcName);
        if (si == null) {
            return new HashMap<String, ProcessingService>();
        }
        return si.getServices();
    }

    public Program addSink(String name, Sink sink) {
        this.fSinks.put(name, sink);
        return this;
    }

    public Map<String, Sink> getSinks() {
        HashMap<String, Sink> map = new HashMap<String, Sink>();
        map.putAll(this.fSinks);
        return map;
    }

    public Program addPipeline(String name, Pipeline pipeline) {
        this.fPipelines.put(name, pipeline);
        return this;
    }

    public Pipeline getPipeline(String plName) {
        return this.fPipelines.get(plName);
    }

    private static class SourceInfo {
        private final Source fSrc;
        private final HashMap<String, ProcessingService> fServices;

        public SourceInfo(Source src) {
            this.fSrc = src;
            this.fServices = new HashMap();
        }

        public void addService(String svcName, ProcessingService service) {
            this.fServices.put(svcName, service);
        }

        public Source getSource() {
            return this.fSrc;
        }

        public Map<String, ProcessingService> getServices() {
            return this.fServices;
        }
    }
}

