/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services;

import io.continual.services.Service;
import io.continual.services.ServiceContainer;
import io.continual.util.time.Clock;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class SimpleService
implements Service {
    private boolean fStopped = true;

    public SimpleService() {
    }

    public SimpleService(ServiceContainer sc, JSONObject config) {
    }

    @Override
    public synchronized void start() throws Service.FailedToStart {
        this.fStopped = false;
        this.onStartRequested();
    }

    @Override
    public synchronized void requestFinish() {
        this.fStopped = true;
        this.onStopRequested();
    }

    public void requestFinishAndWait(long duration, TimeUnit units) throws InterruptedException {
        this.requestFinish();
        long waitUntilMs = Clock.now() + TimeUnit.MILLISECONDS.convert(duration, units);
        while (this.isRunning() && Clock.now() <= waitUntilMs) {
            Thread.sleep(100L);
        }
    }

    @Override
    public synchronized boolean isRunning() {
        return !this.fStopped;
    }

    protected void onStartRequested() throws Service.FailedToStart {
    }

    protected void onStopRequested() {
    }
}

