/*
 * Decompiled with CFR 0.152.
 */
package io.continual.resources.sources;

import io.continual.resources.ResourceLoader;
import io.continual.resources.ResourceSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLoader
implements ResourceSource {
    private final File fBase;
    private static final Logger log = LoggerFactory.getLogger(ResourceLoader.class);

    public FileLoader() {
        this(null);
    }

    public FileLoader(File base) {
        this.fBase = base;
    }

    @Override
    public boolean qualifies(String resourceId) {
        return true;
    }

    @Override
    public InputStream loadResource(String resourceId) throws IOException {
        File f;
        File file = f = this.fBase == null ? new File(resourceId) : new File(this.fBase, resourceId);
        if (f.exists()) {
            try {
                return new FileInputStream(resourceId);
            }
            catch (FileNotFoundException x) {
                log.warn("File not found after exists() returned true.", (Throwable)x);
            }
        }
        return null;
    }
}

