/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.SSLConf;
import org.apache.tomcat.util.net.openssl.OpenSSLConfCmd;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLConf
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(OpenSSLConf.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLConf.class);
    private final List<OpenSSLConfCmd> commands = new ArrayList<OpenSSLConfCmd>();

    public void addCmd(OpenSSLConfCmd cmd) {
        this.commands.add(cmd);
    }

    public List<OpenSSLConfCmd> getCommands() {
        return this.commands;
    }

    public boolean check(long cctx) throws Exception {
        boolean result = true;
        Iterator<OpenSSLConfCmd> i$ = this.commands.iterator();
        while (i$.hasNext()) {
            int rc;
            OpenSSLConfCmd command;
            OpenSSLConfCmd cmd = command = i$.next();
            String name = cmd.getName();
            String value = cmd.getValue();
            if (name == null) {
                log.error(sm.getString("opensslconf.noCommandName", value));
                result = false;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("opensslconf.checkCommand", name, value));
            }
            try {
                rc = SSLConf.check(cctx, name, value);
            }
            catch (Exception e) {
                log.error(sm.getString("opensslconf.checkFailed"));
                return false;
            }
            if (rc <= 0) {
                log.error(sm.getString("opensslconf.failedCommand", name, value, Integer.toString(rc)));
                result = false;
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug(sm.getString("opensslconf.resultCommand", name, value, Integer.toString(rc)));
        }
        if (!result) {
            log.error(sm.getString("opensslconf.checkFailed"));
        }
        return result;
    }

    public boolean apply(long cctx, long ctx) throws Exception {
        int rc;
        boolean result = true;
        SSLConf.assign(cctx, ctx);
        Iterator<OpenSSLConfCmd> i$ = this.commands.iterator();
        while (i$.hasNext()) {
            OpenSSLConfCmd command;
            OpenSSLConfCmd cmd = command = i$.next();
            String name = cmd.getName();
            String value = cmd.getValue();
            if (name == null) {
                log.error(sm.getString("opensslconf.noCommandName", value));
                result = false;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("opensslconf.applyCommand", name, value));
            }
            try {
                rc = SSLConf.apply(cctx, name, value);
            }
            catch (Exception e) {
                log.error(sm.getString("opensslconf.applyFailed"));
                return false;
            }
            if (rc <= 0) {
                log.error(sm.getString("opensslconf.failedCommand", name, value, Integer.toString(rc)));
                result = false;
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug(sm.getString("opensslconf.resultCommand", name, value, Integer.toString(rc)));
        }
        rc = SSLConf.finish(cctx);
        if (rc <= 0) {
            log.error(sm.getString("opensslconf.finishFailed", Integer.toString(rc)));
            result = false;
        }
        if (!result) {
            log.error(sm.getString("opensslconf.applyFailed"));
        }
        return result;
    }
}

