/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.tools;

import io.continual.iam.IamDb;
import io.continual.iam.access.AccessControlList;
import io.continual.iam.access.AclUpdateListener;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.impl.common.CommonJsonDb;
import io.continual.iam.impl.common.CommonJsonGroup;
import io.continual.iam.impl.common.CommonJsonIdentity;
import io.continual.iam.impl.s3.S3IamDb;
import io.continual.iam.tools.IamDbTool;
import java.io.PrintStream;
import java.util.Vector;

public class S3IamDbTool
extends IamDbTool<CommonJsonIdentity, CommonJsonGroup> {
    public static void main(String[] args) throws Exception {
        new S3IamDbTool().runFromMain(args);
    }

    protected IamDb<CommonJsonIdentity, CommonJsonGroup> createDb(Vector<String> args, PrintStream outTo) throws IamSvcException {
        if (args.size() != 4) {
            outTo.println("usage: connect <accessKey> <secret> <bucket> <pathPrefix>");
            throw new IamSvcException("Incorrect usage for connect.");
        }
        return new S3IamDb.Builder().withAccessKey(args.elementAt(0)).withSecretKey(args.elementAt(1)).withBucket(args.elementAt(2)).withPathPrefix(args.elementAt(3)).usingAclFactory(new IamDbAclFactory()).build();
    }

    private class IamDbAclFactory
    implements CommonJsonDb.AclFactory {
        private IamDbAclFactory() {
        }

        public AccessControlList createDefaultAcl(AclUpdateListener acll) {
            return new AccessControlList(acll);
        }
    }
}

