/*
 * Decompiled with CFR 0.152.
 */
package io.continual.restHttp;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedContentReader {
    private static final long kMaxTimeDiffMs = 600000L;
    private static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT");
    public static final String kPreferredDateFormat = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String[] kDateFormats = new String[]{"EEE MMM dd HH:mm:ss yyyy", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss zzz", "yyyy-MM-dd'T'HH:mm:ssz", "EEE, dd MMM yy HH:mm:ss z", "EEE, dd MMM yy HH:mm z", "dd MMM yy HH:mm:ss z", "dd MMM yy HH:mm z", "EEE MMM dd HH:mm:ss z yyyy"};
    private static final Logger log = LoggerFactory.getLogger(SignedContentReader.class);
    private static final boolean skAuthLogging = true;

    public static String getSignedContent(ApiRequestData req, String dateHeader, String magicHeader, String apiProductTag) throws BadAuthFormatException {
        String httpDateString = req.getFirstValue("Date");
        String customDateString = req.getFirstValue(dateHeader);
        String apiMagic = req.getFirstValue(magicHeader);
        return SignedContentReader.getSignedContent(httpDateString, customDateString, apiMagic, apiProductTag);
    }

    public static String getSignedContent(String httpDateString, String customDateString, String apiProductTag) throws BadAuthFormatException {
        return SignedContentReader.getSignedContent(httpDateString, customDateString, null, apiProductTag);
    }

    public static String getSignedContent(String httpDateString, String customDateString, String apiMagic, String apiProductTag) throws BadAuthFormatException {
        long thenMs;
        String dateString;
        String string = dateString = customDateString == null ? httpDateString : customDateString;
        if (dateString == null) {
            SignedContentReader.authLog("Missing date string in header.");
            throw new BadAuthFormatException("Couldn't authenticate this request.");
        }
        Date result = null;
        for (String dateFormat : kDateFormats) {
            SimpleDateFormat parser = new SimpleDateFormat(dateFormat, Locale.US);
            if (!dateFormat.contains("z")) {
                parser.setTimeZone(TIMEZONE_GMT);
            }
            try {
                result = parser.parse(dateString);
                break;
            }
            catch (ParseException parseException) {
            }
        }
        if (result == null) {
            SignedContentReader.authLog("No parser could handle [" + dateString + "].");
            throw new BadAuthFormatException("Couldn't authenticate this request.");
        }
        Date now = new Date();
        long nowMs = now.getTime();
        long diffMs = Math.abs(nowMs - (thenMs = result.getTime()));
        if (diffMs > 600000L) {
            SignedContentReader.authLog("[" + dateString + "] is older than " + 600000L + " ms, at " + diffMs + " ms from now.");
            throw new BadAuthFormatException("Couldn't authenticate this request.");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(apiProductTag);
        sb.append(".");
        sb.append(dateString);
        if (apiMagic != null) {
            sb.append(apiMagic);
        }
        return sb.toString();
    }

    private static void authLog(String msg) {
        log.info(msg);
    }

    public static interface ApiRequestData {
        public String getFirstValue(String var1);

        public String[] getValuesArray(String var1);
    }

    public static class BadAuthFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BadAuthFormatException(String msg) {
            super(msg);
        }
    }
}

