/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.context;

import io.continual.http.service.framework.context.CHttpRequest;
import io.continual.http.service.framework.inspection.CHttpObserver;
import io.continual.http.service.framework.inspection.impl.NoopInspector;
import io.continual.util.data.TypeConvertor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class StdRequest
implements CHttpRequest {
    private final HttpServletRequest fRequest;
    private final HashMap<String, String[]> fParamOverrides;
    private final CHttpObserver fInspector;

    public StdRequest(HttpServletRequest r) {
        this(r, new NoopInspector());
    }

    public StdRequest(HttpServletRequest r, CHttpObserver inspector) {
        this.fRequest = r;
        this.fParamOverrides = new HashMap();
        this.fInspector = inspector;
        this.fInspector.method(this.getMethod()).onUrl(this.getUrl()).queryString(this.getQueryString()).withHeaders(() -> this.getAllHeaders());
    }

    @Override
    public String getUrl() {
        return this.fRequest.getRequestURL().toString();
    }

    @Override
    public boolean isSecure() {
        return this.fRequest.isSecure();
    }

    @Override
    public String getQueryString() {
        String qs = this.fRequest.getQueryString();
        if (qs != null && qs.length() == 0) {
            return null;
        }
        return qs;
    }

    @Override
    public String getMethod() {
        return this.fRequest.getMethod();
    }

    @Override
    public String getPathInContext() {
        String ctxPath = this.fRequest.getContextPath();
        int ctxPathLen = ctxPath.length();
        return this.fRequest.getRequestURI().substring(ctxPathLen);
    }

    @Override
    public String getFirstHeader(String h) {
        return StdRequest.getFirstHeader(this.fRequest, h);
    }

    @Override
    public List<String> getHeader(String h) {
        return StdRequest.getHeader(this.fRequest, h);
    }

    @Override
    public Map<String, List<String>> getAllHeaders() {
        return StdRequest.getAllHeaders(this.fRequest);
    }

    @Override
    public String getContentType() {
        String result = this.fRequest.getContentType();
        this.fInspector.contentTypeRequest(result);
        return result;
    }

    @Override
    public int getContentLength() {
        int result = this.fRequest.getContentLength();
        this.fInspector.contentLengthRequest(result);
        return result;
    }

    @Override
    public InputStream getBodyStream() throws IOException {
        return this.fInspector.wrap(this.fRequest.getInputStream());
    }

    @Override
    public BufferedReader getBodyStreamAsText() throws IOException {
        return new BufferedReader(new InputStreamReader(this.getBodyStream()));
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Map m = this.fRequest.getParameterMap();
        map.putAll(m);
        map.putAll(this.fParamOverrides);
        return map;
    }

    @Override
    public String getParameter(String key) {
        if (this.fParamOverrides.containsKey(key)) {
            String[] o = this.fParamOverrides.get(key);
            return o.length > 0 ? o[0] : "";
        }
        return this.fRequest.getParameter(key);
    }

    @Override
    public String getParameter(String key, String defVal) {
        String p = this.getParameter(key);
        if (p == null) {
            p = defVal;
        }
        return p;
    }

    @Override
    public int getIntParameter(String key, int defVal) {
        int result = defVal;
        String p = this.getParameter(key);
        if (p != null) {
            try {
                result = TypeConvertor.convertToInt((String)p);
            }
            catch (Exception x) {
                result = defVal;
            }
        }
        return result;
    }

    @Override
    public long getLongParameter(String key, long defVal) {
        long result = defVal;
        String p = this.getParameter(key);
        if (p != null) {
            try {
                result = TypeConvertor.convertToLong((String)p);
            }
            catch (Exception x) {
                result = defVal;
            }
        }
        return result;
    }

    @Override
    public double getDoubleParameter(String key, double defVal) {
        double result = defVal;
        String p = this.getParameter(key);
        if (p != null) {
            try {
                result = TypeConvertor.convertToDouble((String)p);
            }
            catch (Exception x) {
                result = defVal;
            }
        }
        return result;
    }

    @Override
    public boolean getBooleanParameter(String key, boolean defVal) {
        boolean result = defVal;
        String p = this.getParameter(key);
        if (p != null) {
            try {
                result = TypeConvertor.convertToBooleanBroad((String)p);
            }
            catch (Exception x) {
                result = defVal;
            }
        }
        return result;
    }

    @Override
    public char getCharParameter(String key, char defVal) {
        char result = defVal;
        String p = this.getParameter(key);
        if (p != null && p.length() == 1) {
            result = p.charAt(0);
        }
        return result;
    }

    @Override
    public void changeParameter(String fieldName, String value) {
        this.fParamOverrides.put(fieldName, new String[]{value});
    }

    @Override
    public String getActualRemoteAddress() {
        return StdRequest.getActualRemoteAddress(this.fRequest);
    }

    @Override
    public String getBestRemoteAddress() {
        return StdRequest.getBestRemoteAddress(this.fRequest);
    }

    @Override
    public int getActualRemotePort() {
        return this.fRequest.getRemotePort();
    }

    @Override
    public int getBestRemotePort() {
        return StdRequest.getBestRemotePort(this.fRequest);
    }

    public static String getActualRemoteAddress(HttpServletRequest req) {
        return req.getRemoteAddr();
    }

    public static int getActualRemotePort(HttpServletRequest req) {
        return req.getRemotePort();
    }

    public static String getBestRemoteAddress(HttpServletRequest req) {
        String fwdHost = StdRequest.getFirstHeader(req, "X-Forwarded-For");
        return fwdHost != null ? fwdHost : StdRequest.getActualRemoteAddress(req);
    }

    public static int getBestRemotePort(HttpServletRequest req) {
        String fwdPort = StdRequest.getFirstHeader(req, "X-Forwarded-Port");
        if (fwdPort != null) {
            return Integer.parseInt(fwdPort);
        }
        return StdRequest.getActualRemotePort(req);
    }

    public static String getFirstHeader(HttpServletRequest req, String h) {
        List<String> l = StdRequest.getHeader(req, h);
        return l.size() > 0 ? l.iterator().next() : null;
    }

    public static List<String> getHeader(HttpServletRequest req, String h) {
        LinkedList<String> list = new LinkedList<String>();
        Enumeration e = req.getHeaders(h);
        while (e.hasMoreElements()) {
            list.add(e.nextElement().toString());
        }
        return list;
    }

    public static Map<String, List<String>> getAllHeaders(HttpServletRequest req) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        Enumeration names = req.getHeaderNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String headerName = names.nextElement().toString();
                LinkedList<String> list = new LinkedList<String>();
                result.put(headerName, list);
                Enumeration values = req.getHeaders(headerName);
                if (values == null) continue;
                while (values.hasMoreElements()) {
                    list.add(values.nextElement().toString());
                }
            }
        }
        return result;
    }
}

