/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.filters;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.Filter;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import org.json.JSONObject;

public class Contains
implements Filter {
    private final String fContains;
    private final String fValueExpr;
    private final boolean fCaseSensitive;

    public Contains(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        this(config);
    }

    public Contains(String valueExpr, String contains) throws Builder.BuildFailure {
        this(valueExpr, contains, true);
    }

    public Contains(String valueExpr, String contains, boolean caseSens) throws Builder.BuildFailure {
        this.fValueExpr = valueExpr;
        this.fContains = contains;
        this.fCaseSensitive = caseSens;
    }

    public Contains(JSONObject config) throws Builder.BuildFailure {
        this.fValueExpr = config.getString("value");
        this.fContains = config.getString("contains");
        this.fCaseSensitive = config.optBoolean("caseSensitive", true);
    }

    public JSONObject toJson() {
        JSONObject result = new JSONObject().put("class", (Object)this.getClass().getName()).put("contains", (Object)this.fContains).put("value", (Object)this.fValueExpr).put("caseSensitive", this.fCaseSensitive);
        return result;
    }

    @Override
    public boolean passes(MessageProcessingContext ctx) {
        String value = ctx.evalExpression(this.fValueExpr);
        return this.fCaseSensitive ? value.contains(this.fContains) : value.toLowerCase().contains(this.fValueExpr.toLowerCase());
    }
}

