/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.routing.playish;

import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.routing.playish.CHttpPlayishRouteHandler;
import io.continual.util.data.StreamTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticDirHandler
implements CHttpPlayishRouteHandler {
    public static final String kMaxAge = "chttp.staticFile.cache.maxAgeSeconds";
    private final String fRoutedPath;
    private final String fDir;
    private final String fDefaultPage;
    private static final Logger log = LoggerFactory.getLogger(StaticDirHandler.class);
    static final HashMap<String, String> sfContentTypes = new HashMap();

    public StaticDirHandler(String routedPath, String staticDirInfo) {
        String[] parts = staticDirInfo.split(";");
        if (parts.length < 1) {
            throw new IllegalArgumentException("dir[;defaultpage]");
        }
        this.fRoutedPath = routedPath;
        this.fDir = parts[0];
        this.fDefaultPage = parts.length > 1 ? parts[1] : null;
    }

    @Override
    public void handle(CHttpRequestContext context, List<String> args) {
        String path = context.request().getPathInContext();
        if (path == null || path.length() == 0) {
            log.warn("404 [" + path + "] no path provided");
            context.response().sendError(404, "no path provided");
            return;
        }
        if (path.contains("..")) {
            log.warn("404 [" + path + "] contains parent directory accessor");
            context.response().sendError(404, path + " was not found on this server.");
            return;
        }
        if (!path.startsWith(this.fRoutedPath)) {
            log.warn("404 [" + path + "] does not start with routed path [" + this.fRoutedPath + "]");
            context.response().sendError(404, path + " is not a matching path");
            return;
        }
        String relPath = path.substring(this.fRoutedPath.length());
        String newPath = (relPath.length() == 0 || relPath.equals("/")) && this.fDefaultPage != null ? this.fDir + File.separator + this.fDefaultPage : this.fDir + File.separator + relPath;
        URL in = context.getServlet().findStream(newPath);
        log.info("Path [" + path + "] ==> [" + (in == null ? "<not found>" : in.toString()) + "].");
        if (in == null) {
            context.response().sendError(404, path + " was not found on this server.");
        } else {
            String contentType = StaticDirHandler.mapToContentType(in.toString());
            int cacheMaxAge = context.systemSettings().getInt(kMaxAge, -1);
            if (cacheMaxAge > 0) {
                context.response().writeHeader("Cache-Control", "max-age=" + cacheMaxAge, true);
            }
            try {
                InputStream is = in.openStream();
                OutputStream os = context.response().getStreamForBinaryResponse(contentType);
                StreamTools.copyStream((InputStream)is, (OutputStream)os);
            }
            catch (FileNotFoundException e) {
                log.warn("404 [" + path + "]==>[" + path + "] (" + in.toString() + ")");
                context.response().sendError(404, path + " was not found on this server.");
            }
            catch (IOException e) {
                log.warn("500 [" + in.toString() + "]: " + e.getMessage());
                context.response().sendError(500, e.getMessage());
            }
        }
    }

    public static String mapToContentType(String name) {
        String result;
        int dot = name.lastIndexOf(".");
        if (dot != -1) {
            name = name.substring(dot + 1);
        }
        if ((result = sfContentTypes.get(name)) == null) {
            log.warn("Unknown content type [" + name + "]. Sending text/plain. (See " + StaticDirHandler.class.getSimpleName() + "::sfContentTypes)");
            result = "text/plain";
        }
        return result;
    }

    @Override
    public boolean actionMatches(String fullPath) {
        return false;
    }

    static {
        sfContentTypes.put("css", "text/css");
        sfContentTypes.put("jpg", "image/jpg");
        sfContentTypes.put("gif", "image/gif");
        sfContentTypes.put("png", "image/png");
        sfContentTypes.put("ico", "image/vnd.microsoft.icon");
        sfContentTypes.put("htm", "text/html");
        sfContentTypes.put("html", "text/html");
        sfContentTypes.put("js", "application/javascript");
        sfContentTypes.put("eot", "application/vnd.ms-fontobject");
        sfContentTypes.put("woff", "application/x-font-woff");
        sfContentTypes.put("woff2", "application/x-font-woff2");
        sfContentTypes.put("otf", "application/font-otf");
        sfContentTypes.put("ttf", "application/x-font-ttf");
        sfContentTypes.put("svg", "image/svg+xml");
        sfContentTypes.put("xml", "application/xml");
        sfContentTypes.put("sh", "application/octet-stream");
    }
}

