/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.rcvr;

import io.continual.builder.Builder;
import io.continual.http.app.htmlForms.CHttpFormPostWrapper;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.iam.IamService;
import io.continual.iam.identity.UserContext;
import io.continual.messaging.ContinualMessage;
import io.continual.messaging.ContinualMessagePublisher;
import io.continual.messaging.ContinualMessageSink;
import io.continual.messaging.ContinualMessageStream;
import io.continual.restHttp.ApiContextHelper;
import io.continual.restHttp.HttpServlet;
import io.continual.services.ServiceContainer;
import io.continual.services.rcvr.NotifierTopics;
import io.continual.util.data.StreamTools;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.data.json.JsonVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReceiverApi
extends ApiContextHelper {
    public static final String kSetting_MaxSenderStreamSize = "receiver.events.io.maxInboundMessageSize";
    public static final int kDefault_MaxSenderStreamSize = 0x400000;
    public static final String DEFAULT_TOPIC = "";
    public static final String DEFAULT_PARTITION = "";
    private static final String kMetadataGroup = "rcvr";
    private static final String kMessageId = "msgId";
    private static final String kIntendedAccount = "account";
    private static final String kIntendedTopic = "topic";
    private static final String kEventStreamName = "eventStream";
    private final String fNodeId = sfProcessId;
    private static String sfProcessId = UUID.randomUUID().toString();
    private static AtomicLong sfCounter = new AtomicLong(0L);
    private final IamService<?, ?> fAccts;
    private final ContinualMessagePublisher fMsgPublisher;
    private final ContinualMessageSink fSink;
    private static HashMap<String, ContentTypeHandler> fContentTypeHandlers = new HashMap();

    public ReceiverApi(ServiceContainer sc, JSONObject prefs) throws Builder.BuildFailure {
        String acctSvcName = prefs.optString("accountsService", "accounts");
        this.fAccts = (IamService)sc.get(acctSvcName, IamService.class);
        if (this.fAccts == null) {
            throw new Builder.BuildFailure("ReceiverApi couldn't find accounts service (" + acctSvcName + ")");
        }
        String pubSvcName = prefs.optString("publisherService", "publisher");
        this.fMsgPublisher = (ContinualMessagePublisher)sc.get(pubSvcName, ContinualMessagePublisher.class);
        if (this.fMsgPublisher == null) {
            throw new Builder.BuildFailure("ReceiverApi couldn't find publisher service (" + pubSvcName + ")");
        }
        try {
            this.fSink = this.fMsgPublisher.getTopic(NotifierTopics.USER_EVENTS.toString());
        }
        catch (ContinualMessagePublisher.TopicUnavailableException e) {
            throw new Builder.BuildFailure("ReceiverApi couldn't open topic " + (Object)((Object)NotifierTopics.USER_EVENTS), (Throwable)e);
        }
    }

    public void usage(CHttpRequestContext context) {
        ApiContextHelper.sendStatusOk((CHttpRequestContext)context, (String)"Please review the API documentation for the receiver service. :-)");
    }

    public void postEvents(CHttpRequestContext context) {
        this.postEvents(context, "");
    }

    public void postEvents(CHttpRequestContext context, String topic) {
        this.postEvents(context, topic, "");
    }

    public void postEvents(CHttpRequestContext context, final String topic, final String eventStreamName) {
        ReceiverApi.handleWithApiAuth((CHttpRequestContext)context, (ApiContextHelper.ApiHandler)new ApiContextHelper.ApiHandler(){

            public String handle(CHttpRequestContext context, HttpServlet servlet, UserContext user) {
                Counter count = new Counter();
                try {
                    List incoming = ReceiverApi.this.readPayloadForMessages(context);
                    if (incoming == null) {
                        ReceiverApi.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)("Unsupported content type: " + context.request().getContentType() + " or there was a problem reading the payload."));
                        return null;
                    }
                    String[] acctIdAndTopic = ReceiverApi.this.getAcctIdAndTopic(topic, user);
                    if (!acctIdAndTopic[0].equals(user.getEffectiveUserId())) {
                        ReceiverApi.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)401, (String)"You cannot post to this stream.");
                        return null;
                    }
                    String internalMsgStreamName = acctIdAndTopic[0] + "/" + acctIdAndTopic[1] + "/" + eventStreamName;
                    ContinualMessageStream stream = ContinualMessageStream.fromName((String)internalMsgStreamName);
                    for (JSONObject msgData : incoming) {
                        String id = ReceiverApi.this.makeId();
                        ContinualMessage msg = ContinualMessage.builder().createdBy(user.getUser()).withMessageData(msgData).withMetaDataSection(ReceiverApi.kMetadataGroup).set(ReceiverApi.kMessageId, (Object)id).set(ReceiverApi.kIntendedAccount, (Object)acctIdAndTopic[0]).set(ReceiverApi.kIntendedTopic, (Object)acctIdAndTopic[1]).set(ReceiverApi.kEventStreamName, (Object)eventStreamName).close().build();
                        ReceiverApi.this.fSink.send(stream, msg);
                        count.bump();
                    }
                    ReceiverApi.sendStatusOk((CHttpRequestContext)context, (JSONObject)new JSONObject().put("received", count.getCount()));
                }
                catch (IOException e) {
                    ReceiverApi.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)e.getMessage());
                }
                catch (JSONException e) {
                    ReceiverApi.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)e.getMessage());
                }
                return null;
            }
        });
    }

    private String makeId() {
        return this.fNodeId + ":" + sfCounter.addAndGet(1L);
    }

    private String[] getAcctIdAndTopic(String topic, UserContext user) {
        int colon;
        String acctId = user.getEffectiveUserId();
        String topicResult = topic;
        if (topic != null && (colon = topic.indexOf(58)) > -1) {
            acctId = topic.substring(0, colon);
            topicResult = topic.substring(colon + 1);
        }
        return new String[]{acctId, topicResult};
    }

    private List<JSONObject> readPayloadForMessages(CHttpRequestContext context) throws IOException {
        String contentType = context.request().getContentType();
        if (contentType == null) {
            return null;
        }
        ContentTypeHandler cth = fContentTypeHandlers.get(contentType);
        if (cth == null) {
            return null;
        }
        return cth.handle(context);
    }

    private static String readRequestBody(CHttpRequestContext context) throws IOException {
        byte[] inData = StreamTools.readBytes((InputStream)context.request().getBodyStream(), (int)8192, (int)context.systemSettings().getInt(kSetting_MaxSenderStreamSize, 0x400000));
        return new String(inData);
    }

    private static JSONObject rawJsonToMsg(Object o) {
        JSONObject result = null;
        if (o != null) {
            result = o instanceof JSONObject ? (JSONObject)o : new JSONObject().put("message", (Object)o.toString());
        }
        return result;
    }

    static {
        fContentTypeHandlers.put("application/json", new ContentTypeHandler(){

            @Override
            public List<JSONObject> handle(CHttpRequestContext context) throws IOException {
                try {
                    LinkedList<JSONObject> result = new LinkedList<JSONObject>();
                    String inDataStr = ReceiverApi.readRequestBody(context);
                    if (inDataStr.startsWith("[")) {
                        JSONArray arr = JsonUtil.readJsonArray((String)inDataStr);
                        for (int i = 0; i < arr.length(); ++i) {
                            JSONObject msg = ReceiverApi.rawJsonToMsg(arr.opt(i));
                            if (msg == null) continue;
                            result.add(msg);
                        }
                    } else {
                        JSONObject msg = ReceiverApi.rawJsonToMsg(JsonUtil.readJsonValue((String)inDataStr));
                        if (msg != null) {
                            result.add(msg);
                        }
                    }
                    return result;
                }
                catch (JSONException x) {
                    return null;
                }
            }
        });
        fContentTypeHandlers.put("text/plain", new ContentTypeHandler(){

            @Override
            public List<JSONObject> handle(CHttpRequestContext context) throws IOException {
                LinkedList<JSONObject> result = new LinkedList<JSONObject>();
                String inDataStr = ReceiverApi.readRequestBody(context);
                JSONObject msg = ReceiverApi.rawJsonToMsg(JSONObject.valueToString((Object)inDataStr));
                if (msg != null) {
                    result.add(msg);
                }
                return result;
            }
        });
        ContentTypeHandler webFormHandler = new ContentTypeHandler(){

            @Override
            public List<JSONObject> handle(CHttpRequestContext context) {
                try {
                    LinkedList<JSONObject> result = new LinkedList<JSONObject>();
                    result.add(JsonVisitor.mapOfStringsToObject((Map)new CHttpFormPostWrapper(context.request()).getValues()));
                    return result;
                }
                catch (CHttpFormPostWrapper.ParseException e) {
                    return null;
                }
            }
        };
        fContentTypeHandlers.put("application/x-www-form-urlencoded", webFormHandler);
        fContentTypeHandlers.put("multipart/form-data", webFormHandler);
    }

    private static interface ContentTypeHandler {
        public List<JSONObject> handle(CHttpRequestContext var1) throws IOException;
    }

    private static class Counter {
        private long fCount = 0L;

        Counter() {
        }

        long getCount() {
            return this.fCount;
        }

        void bump() {
            ++this.fCount;
        }
    }
}

