/*
 * Decompiled with CFR 0.152.
 */
package io.continual.onap.services.publisher;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnapMsgRouterPublisher {
    private final LinkedList<String> fHosts;
    private final String fTopic;
    private final long fWaitTimeoutMs;
    private final String fUser;
    private final String fPwd;
    private final boolean fDefaultHttps;
    private final OkHttpClient fHttpClient;
    private final Logger fLog;
    private static final MediaType kCambriaZip = MediaType.get((String)"application/cambria-zip");
    private static final Charset kUtf8 = Charset.forName("UTF-8");
    private static final Logger defaultLog = LoggerFactory.getLogger(OnapMsgRouterPublisher.class);
    private static final int k200_ok = 200;
    private static final int k202_accepted = 202;
    private static final int k300_multipleChoices = 300;
    private static final int k400_badRequest = 400;
    private static final int k500_internalServerError = 500;
    private static final int k503_serviceUnavailable = 503;
    private static final OnapMrResponse skAccepted = new OnapMrResponse(202, "Accepted.");
    private static final OnapMrResponse skSvcUnavailable = new OnapMrResponse(503, "No Message Router server could acknowledge the request.");

    public static Builder localTest() {
        return new Builder().withHost("localhost").onTopic("TEST-TOPIC").waitingAtMost(30000L);
    }

    public static Builder builder() {
        return new Builder();
    }

    public OnapMrResponse send(Message msg) {
        LinkedList<Message> msgs = new LinkedList<Message>();
        msgs.add(msg);
        return this.send(msgs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OnapMrResponse send(List<Message> msgList) {
        ByteArrayOutputStream baos;
        if (msgList.size() < 1) {
            return skAccepted;
        }
        try {
            baos = new ByteArrayOutputStream();
            GZIPOutputStream wrapperOs = new GZIPOutputStream(baos);
            for (Message m : msgList) {
                byte[] streamBytes = m.fStreamName.getBytes(kUtf8);
                byte[] payloadBytes = m.getBytesForSend();
                ((OutputStream)wrapperOs).write(("" + streamBytes.length).getBytes(kUtf8));
                ((OutputStream)wrapperOs).write(46);
                ((OutputStream)wrapperOs).write(("" + payloadBytes.length).getBytes(kUtf8));
                ((OutputStream)wrapperOs).write(46);
                ((OutputStream)wrapperOs).write(streamBytes);
                ((OutputStream)wrapperOs).write(payloadBytes);
                ((OutputStream)wrapperOs).write(10);
            }
            ((OutputStream)wrapperOs).close();
            baos.close();
        }
        catch (IOException e) {
            this.fLog.error("Error while building payload for MR publish. Returning 400 Bad Request. " + e.getMessage(), (Throwable)e);
            return new OnapMrResponse(400, "Unable to build payload.");
        }
        ArrayList<String> hostsLeft = new ArrayList<String>();
        hostsLeft.addAll(this.fHosts);
        long noResponseTimeoutMs = OnapMsgRouterPublisher.now() + this.fWaitTimeoutMs;
        while (OnapMsgRouterPublisher.now() < noResponseTimeoutMs) {
            if (hostsLeft.size() <= 0) return skSvcUnavailable;
            String host = (String)hostsLeft.remove(0);
            String path = this.buildPath(host);
            RequestBody body = RequestBody.create((MediaType)kCambriaZip, (byte[])baos.toByteArray());
            Request.Builder reqBuilder = new Request.Builder().url(path).post(body);
            if (this.fUser != null) {
                reqBuilder.addHeader("Authorization", Credentials.basic((String)this.fUser, (String)this.fPwd));
            }
            Request req = reqBuilder.build();
            try {
                Response response = this.fHttpClient.newCall(req).execute();
                Throwable throwable = null;
                try {
                    int statusCode = response.code();
                    if (OnapMsgRouterPublisher.isSuccess(statusCode) || OnapMsgRouterPublisher.isClientFailure(statusCode)) {
                        OnapMrResponse onapMrResponse = new OnapMrResponse(statusCode, response.message());
                        return onapMrResponse;
                    }
                    if (!OnapMsgRouterPublisher.isServerFailure(statusCode)) continue;
                    this.fLog.warn("Error posting to MR host [" + host + "]: " + statusCode);
                    this.demote(host);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (IOException x) {
                this.fLog.warn("Error posting to MR host [" + host + "]: " + x.getMessage());
                this.demote(host);
            }
        }
        return skSvcUnavailable;
    }

    private String buildPath(String host) {
        StringBuilder sb = new StringBuilder();
        if (!host.contains("://")) {
            sb.append(this.fDefaultHttps ? "https://" : "http://");
        }
        sb.append(host);
        if (!host.contains(":")) {
            sb.append(host.startsWith("https://") ? ":3905" : ":3904");
        }
        sb.append("/events/");
        sb.append(OnapMsgRouterPublisher.urlEncode(this.fTopic));
        return sb.toString();
    }

    private void demote(String host) {
        this.fHosts.remove(host);
        this.fHosts.addLast(host);
    }

    private OnapMsgRouterPublisher(Builder builder) {
        if (builder.fHosts.size() < 1) {
            throw new IllegalArgumentException("No hosts provided.");
        }
        if (builder.fTopic == null || builder.fTopic.length() < 1) {
            throw new IllegalArgumentException("No topic provided.");
        }
        this.fHosts = new LinkedList();
        this.fHosts.addAll(builder.fHosts);
        this.fTopic = builder.fTopic;
        this.fWaitTimeoutMs = builder.fWaitTimeoutMs;
        this.fDefaultHttps = builder.fDefaultHttps;
        this.fUser = builder.fUser;
        this.fPwd = builder.fPwd;
        if (this.fUser != null && this.fPwd == null) {
            throw new IllegalArgumentException("When a username is provided, a password is required.");
        }
        if (builder.fLog == null) {
            throw new IllegalArgumentException("You must provide a logger.");
        }
        this.fLog = builder.fLog;
        this.fHttpClient = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
    }

    private static boolean isSuccess(int code) {
        return code >= 200 && code < 300;
    }

    private static boolean isClientFailure(int code) {
        return code >= 400 && code < 500;
    }

    private static boolean isServerFailure(int code) {
        return code >= 500;
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private static String urlEncode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ Logger access$100() {
        return defaultLog;
    }

    public static class OnapMrResponse {
        private final int fStatusCode;
        private final String fMsg;

        public OnapMrResponse(int statusCode, String msg) {
            this.fStatusCode = statusCode;
            this.fMsg = msg;
        }

        public int getStatusCode() {
            return this.fStatusCode;
        }

        public String getStatusText() {
            return this.fMsg;
        }
    }

    public static class Message {
        public final String fStreamName;
        public final String fData;

        public Message(String eventStreamName, String payload) {
            this.fStreamName = eventStreamName;
            this.fData = payload;
        }

        public byte[] getBytesForSend() {
            return this.fData.toString().getBytes(kUtf8);
        }
    }

    public static class Builder {
        private final LinkedList<String> fHosts = new LinkedList();
        private String fTopic = null;
        private long fWaitTimeoutMs = 30000L;
        private String fUser = null;
        private String fPwd = null;
        private Logger fLog = OnapMsgRouterPublisher.access$100();
        private boolean fDefaultHttps = false;

        public Builder withHost(String host) {
            this.fHosts.add(host);
            return this;
        }

        public Builder withHosts(Collection<String> hosts) {
            for (String host : hosts) {
                this.withHost(host);
            }
            return this;
        }

        public Builder withHosts(String[] hosts) {
            for (String host : hosts) {
                this.withHost(host);
            }
            return this;
        }

        public Builder forgetHosts() {
            this.fHosts.clear();
            return this;
        }

        public Builder onTopic(String topic) {
            this.fTopic = topic;
            return this;
        }

        public Builder waitingAtMost(long ms) {
            this.fWaitTimeoutMs = ms;
            return this;
        }

        public Builder logTo(Logger log) {
            this.fLog = log;
            return this;
        }

        public Builder asUser(String user, String pwd) {
            this.fUser = user;
            this.fPwd = user == null ? null : pwd;
            return this;
        }

        public Builder defaultHttp() {
            return this.defaultHttps(false);
        }

        public Builder defaultHttps() {
            return this.defaultHttps(true);
        }

        public Builder defaultHttps(boolean https) {
            this.fDefaultHttps = https;
            return this;
        }

        public OnapMsgRouterPublisher build() {
            return new OnapMsgRouterPublisher(this);
        }
    }
}

