/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl.zk;

import io.continual.builder.Builder;
import io.continual.iam.access.AccessControlList;
import io.continual.iam.access.AclUpdateListener;
import io.continual.iam.exceptions.IamBadRequestException;
import io.continual.iam.exceptions.IamIdentityDoesNotExist;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.ApiKey;
import io.continual.iam.identity.JwtValidator;
import io.continual.iam.impl.common.CommonJsonApiKey;
import io.continual.iam.impl.common.CommonJsonDb;
import io.continual.iam.impl.common.CommonJsonGroup;
import io.continual.iam.impl.common.CommonJsonIdentity;
import io.continual.iam.impl.common.jwt.JwtProducer;
import io.continual.iam.impl.common.jwt.SimpleJwtValidator;
import io.continual.services.ServiceContainer;
import io.continual.util.data.StreamTools;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.time.Clock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.KeeperException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZkIamDb<I extends CommonJsonIdentity, G extends CommonJsonGroup>
extends CommonJsonDb<I, G> {
    private final CuratorFramework fZk;
    private static final Logger log = LoggerFactory.getLogger(ZkIamDb.class);

    public static <I extends CommonJsonIdentity, G extends CommonJsonGroup> void populateBuilderFrom(final Builder<I, G> b, ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        ExpressionEvaluator evaluator = sc.getExprEval(config);
        final String sysAdminGroup = evaluator.evaluateText(config.optString("sysAdminGroup", "sysadmin"));
        JSONObject jwt = config.optJSONObject("jwt");
        if (jwt != null) {
            String jwtIssuer = jwt.optString("issuer", null);
            String jwtSecret = jwt.optString("sha256Key", null);
            if (jwtIssuer != null && jwtSecret != null) {
                b.withJwtProducer(new JwtProducer.Builder().withIssuerName(jwtIssuer).usingSigningKey(jwtSecret).build());
            }
        }
        JSONObject zkConfig = config.getJSONObject("zk");
        b.connectingTo(evaluator.evaluateText(zkConfig.getString("connectionString"))).withPathPrefix(evaluator.evaluateText(config.optString("pathPrefix", ""))).usingAclFactory(new CommonJsonDb.AclFactory(){

            public AccessControlList createDefaultAcl(AclUpdateListener acll) {
                AccessControlList acl = new AccessControlList(acll);
                acl.permit(sysAdminGroup, "read").permit(sysAdminGroup, "update").permit(sysAdminGroup, "create").permit(sysAdminGroup, "delete");
                return acl;
            }
        });
        if (jwt != null) {
            JSONArray auths = jwt.optJSONArray("thirdPartyAuth");
            JsonVisitor.forEachElement((JSONArray)auths, (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, Builder.BuildFailure>(){

                public boolean visit(JSONObject authEntry) throws JSONException, Builder.BuildFailure {
                    String keys = authEntry.optString("keys");
                    SimpleJwtValidator v = new SimpleJwtValidator.Builder().named(authEntry.optString("name", "(anonymous)")).forIssuer(authEntry.getString("issuer")).forAudience(authEntry.getString("audience")).getPublicKeysFrom(keys).build();
                    b.addJwtValidator((JwtValidator)v);
                    return true;
                }
            });
        }
    }

    protected ZkIamDb(Builder<I, G> b) throws IamSvcException {
        super(((Builder)b).fAclFactory, ((Builder)b).fJwtProducer);
        this.fZk = CuratorFrameworkFactory.builder().namespace(((Builder)b).prefix).connectString(((Builder)b).fZkConnectionString).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).build();
    }

    public void start() throws IamSvcException {
        super.start();
        this.fZk.start();
        this.ensurePathExists("users");
        this.ensurePathExists("groups");
        this.ensurePathExists("apikeys/byKey");
        this.ensurePathExists("acls");
        this.ensurePathExists("tags/byTag");
        this.ensurePathExists("tags/byUser");
        this.ensurePathExists("aliases/byKey");
        this.ensurePathExists("aliases/byUser");
        this.ensurePathExists("invalidJwts");
    }

    public void close() {
        this.fZk.close();
    }

    public Map<String, I> loadAllUsers() throws IamSvcException {
        HashMap<String, CommonJsonIdentity> result = new HashMap<String, CommonJsonIdentity>();
        for (String userId : this.getAllUsers()) {
            result.put(userId, this.loadUser(userId));
        }
        return result;
    }

    public Collection<String> getAllUsers() throws IamSvcException {
        String key = this.concatPathParts("users");
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.loadKeysBelow(key));
        return result;
    }

    public Collection<String> getAllGroups() throws IamSvcException {
        String prefix = this.concatPathParts("groups");
        LinkedList<String> result = new LinkedList<String>();
        for (String key : this.loadKeysBelow(prefix)) {
            String localPart = key.substring(prefix.length());
            if (localPart.length() <= 0) continue;
            result.add(localPart);
        }
        return result;
    }

    public List<String> findUsers(String startingWith) throws IamSvcException {
        String sysPrefix = this.concatPathParts("users");
        String prefix = this.concatPathParts(sysPrefix, startingWith);
        List<String> matches = this.loadKeysBelow(prefix);
        LinkedList<String> result = new LinkedList<String>();
        for (String match : matches) {
            result.add(match.substring(sysPrefix.length() + 1));
        }
        return result;
    }

    public void sweepExpiredTags() throws IamSvcException {
        for (String key : this.loadKeysBelow("/tags/byTag")) {
            this.loadTagObject(key, false);
        }
    }

    String concatPathParts(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (part.startsWith("/")) {
                part = part.substring(1);
            }
            if (part.endsWith("/")) {
                part = part.substring(0, part.length() - 1);
            }
            sb.append("/").append(part);
        }
        return sb.toString();
    }

    String makeUserId(String userId) {
        return this.concatPathParts("users/", userId);
    }

    String makeGroupId(String groupId) {
        return this.concatPathParts("groups/", groupId);
    }

    String makeByApiKeyId(String apiKeyId) {
        return this.concatPathParts("apikeys/byKey/", apiKeyId);
    }

    String makeAclId(String aclId) {
        return this.concatPathParts("acls/", aclId);
    }

    String makeByTagId(String tagId) {
        return this.concatPathParts("tags/byTag/", tagId);
    }

    String makeByUserTagId(String userId, String type) {
        return this.concatPathParts("tags/byUser/", userId, type);
    }

    String makeByAliasId(String alias) {
        return this.concatPathParts("aliases/byKey/", alias);
    }

    String makeByUserAliasId(String userId) {
        return this.concatPathParts("aliases/byUser/", userId);
    }

    String makeJwtTokenId(String token) {
        return this.concatPathParts("invalidJwts/", token);
    }

    private InputStream load(String key) throws IamSvcException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.loadTo(key, baos)) {
            return new ByteArrayInputStream(baos.toByteArray());
        }
        return null;
    }

    private JSONObject loadObject(String key) throws IamSvcException {
        long startMs = Clock.now();
        try {
            InputStream is = this.load(key);
            if (is == null) {
                return null;
            }
            JSONObject result = new JSONObject((JSONTokener)new CommentedJsonTokener(is));
            long durMs = Clock.now() - startMs;
            if (log.isDebugEnabled()) {
                log.debug("ZkIamDb.loadObject ( " + key + " ): from ZK, " + durMs + " ms");
            }
            return result;
        }
        catch (JSONException e) {
            throw new IamSvcException((Throwable)e);
        }
    }

    private boolean loadTo(String key, OutputStream os) throws IamSvcException {
        try {
            byte[] data = (byte[])this.fZk.getData().forPath(key);
            StreamTools.copyStream((InputStream)new ByteArrayInputStream(data), (OutputStream)os);
            return true;
        }
        catch (KeeperException x) {
            switch (x.code()) {
                case NONODE: {
                    log.info("No node {}", (Object)key);
                    return false;
                }
            }
            throw new IamSvcException((Throwable)x);
        }
        catch (Exception x) {
            throw new IamSvcException((Throwable)x);
        }
    }

    List<String> loadKeysBelow(String key) throws IamSvcException {
        LinkedList<String> result = new LinkedList<String>();
        try {
            List children = (List)this.fZk.getChildren().forPath(key);
            result.addAll(children);
        }
        catch (KeeperException x) {
            switch (x.code()) {
                case NONODE: {
                    log.info("No node {}", (Object)key);
                    break;
                }
                default: {
                    throw new IamSvcException((Throwable)x);
                }
            }
        }
        catch (Exception x) {
            throw new IamSvcException((Throwable)x);
        }
        return result;
    }

    void storeObject(String key, JSONObject o) throws IamSvcException {
        try {
            String data = o.toString();
            byte[] bytes = data.getBytes("UTF-8");
            this.fZk.create().orSetData().creatingParentsIfNeeded().forPath(key, bytes);
        }
        catch (Exception x) {
            throw new IamSvcException((Throwable)x);
        }
    }

    private void deleteObject(String key) throws IamSvcException {
        try {
            this.fZk.delete().forPath(key);
        }
        catch (Exception x) {
            throw new IamSvcException((Throwable)x);
        }
    }

    protected JSONObject createNewUser(String id) {
        return CommonJsonIdentity.initializeIdentity();
    }

    protected JSONObject loadUserObject(String id) throws IamSvcException {
        return this.loadObject(this.makeUserId(id));
    }

    protected void storeUserObject(String id, JSONObject data) throws IamSvcException {
        this.storeObject(this.makeUserId(id), data);
    }

    protected void deleteUserObject(String id) throws IamSvcException {
        this.deleteObject(this.makeUserId(id));
    }

    protected JSONObject createNewGroup(String id, String groupDesc) {
        return CommonJsonGroup.initializeGroup((String)groupDesc);
    }

    protected JSONObject loadGroupObject(String id) throws IamSvcException {
        return this.loadObject(this.makeGroupId(id));
    }

    protected void storeGroupObject(String id, JSONObject data) throws IamSvcException {
        this.storeObject(this.makeGroupId(id), data);
    }

    protected void deleteGroupObject(String id) throws IamSvcException {
        this.deleteObject(this.makeGroupId(id));
    }

    protected JSONObject createApiKeyObject(String userId, String apiKey, String apiSecret) {
        return CommonJsonApiKey.initialize((String)apiSecret, (String)userId);
    }

    protected JSONObject loadApiKeyObject(String id) throws IamSvcException {
        return this.loadObject(this.makeByApiKeyId(id));
    }

    protected void storeApiKeyObject(String id, JSONObject apiKeyObject) throws IamSvcException, IamBadRequestException {
        TreeSet existing;
        String userId = apiKeyObject.optString("userId", null);
        if (userId == null) {
            throw new IamBadRequestException("no user specified for api key");
        }
        JSONObject user = this.loadUserObject(userId);
        if (user == null) {
            throw new IamIdentityDoesNotExist(userId);
        }
        this.storeObject(this.makeByApiKeyId(id), apiKeyObject);
        JSONArray userApiKeys = user.optJSONArray("apiKeys");
        if (userApiKeys == null) {
            userApiKeys = new JSONArray();
            user.put("apiKeys", (Object)userApiKeys);
        }
        if (!(existing = new TreeSet(JsonVisitor.arrayToList((JSONArray)userApiKeys))).contains(id)) {
            userApiKeys.put((Object)id);
            this.storeUserObject(userId, user);
        }
    }

    protected void deleteApiKeyObject(String id) throws IamSvcException {
        String userId;
        JSONObject user;
        JSONArray userApiKeys;
        JSONObject apiKey = this.loadApiKeyObject(id);
        if (apiKey != null && (userApiKeys = (user = this.loadUserObject(userId = apiKey.getString("userId"))).optJSONArray("apiKeys")) != null && JsonUtil.removeStringFromArray((JSONArray)userApiKeys, (String)id)) {
            this.storeUserObject(userId, user);
        }
        this.deleteObject(this.makeByApiKeyId(id));
    }

    protected ApiKey instantiateApiKey(String id, JSONObject data) {
        return new CommonJsonApiKey(id, data);
    }

    protected Collection<String> loadApiKeysForUser(String userId) throws IamSvcException, IamIdentityDoesNotExist {
        JSONObject user = this.loadUserObject(userId);
        if (user == null) {
            throw new IamIdentityDoesNotExist(userId);
        }
        JSONArray userApiKeys = user.optJSONArray("apiKeys");
        if (userApiKeys != null) {
            return JsonVisitor.arrayToList((JSONArray)userApiKeys);
        }
        return new LinkedList<String>();
    }

    protected JSONObject loadAclObject(String id) throws IamSvcException {
        return this.loadObject(this.makeAclId(id));
    }

    protected void storeAclObject(String id, JSONObject data) throws IamSvcException {
        this.storeObject(this.makeAclId(id), data);
    }

    protected void deleteAclObject(String id) throws IamSvcException {
        this.deleteObject(this.makeAclId(id));
    }

    protected JSONObject loadTagObject(String id, boolean expiredOk) throws IamSvcException {
        JSONObject entry = this.loadObject(this.makeByTagId(id));
        if (entry == null) {
            return null;
        }
        long expireEpoch = entry.getLong("expireEpoch");
        if (expireEpoch < Clock.now() / 1000L && !expiredOk) {
            String userId = entry.optString("userId", null);
            String tagType = entry.optString("tagType", entry.optString("type", null));
            if (userId == null || tagType == null) {
                log.warn("Tag " + id + " is damaged.");
            } else {
                this.deleteTagObject(id, userId, tagType);
                log.info("Tag " + id + " (" + userId + "/" + tagType + ") deleted.");
            }
            return null;
        }
        return entry;
    }

    protected JSONObject loadTagObject(String userId, String appTagType, boolean expiredOk) throws IamSvcException {
        JSONObject entry = this.loadObject(this.makeByUserTagId(userId, appTagType));
        if (entry == null) {
            return null;
        }
        long expireEpoch = entry.getLong("expireEpoch");
        if (expireEpoch < Clock.now() / 1000L && !expiredOk) {
            this.removeMatchingTag(userId, appTagType);
            return null;
        }
        return entry;
    }

    protected void storeTagObject(String id, String userId, String appTagType, JSONObject data) throws IamSvcException {
        this.storeObject(this.makeByTagId(id), data);
        this.storeObject(this.makeByUserTagId(userId, appTagType), data);
    }

    protected void deleteTagObject(String id, String userId, String appTagType) throws IamSvcException {
        this.deleteObject(this.makeByTagId(id));
        this.deleteObject(this.makeByUserTagId(userId, appTagType));
    }

    protected JSONObject loadAliasObject(String id) throws IamSvcException {
        return this.loadObject(this.makeByAliasId(id));
    }

    protected void storeAliasObject(String id, JSONObject aliasObject) throws IamSvcException, IamBadRequestException {
        TreeSet existing;
        String userId = aliasObject.optString("userId", null);
        if (userId == null) {
            throw new IamBadRequestException("no user specified for alias");
        }
        JSONObject user = this.loadUserObject(userId);
        if (user == null) {
            throw new IamIdentityDoesNotExist(userId);
        }
        this.storeObject(this.makeByAliasId(id), aliasObject);
        JSONArray userAliases = user.optJSONArray("aliases");
        if (userAliases == null) {
            userAliases = new JSONArray();
            user.put("aliases", (Object)userAliases);
        }
        if (!(existing = new TreeSet(JsonVisitor.arrayToList((JSONArray)userAliases))).contains(id)) {
            userAliases.put((Object)id);
            this.storeUserObject(userId, user);
        }
    }

    protected void deleteAliasObject(String id) throws IamSvcException {
        String userId;
        JSONObject user;
        JSONArray userAliases;
        JSONObject alias = this.loadAliasObject(id);
        if (alias != null && (userAliases = (user = this.loadUserObject(userId = alias.getString("userId"))).optJSONArray("aliases")) != null && JsonUtil.removeStringFromArray((JSONArray)userAliases, (String)id)) {
            this.storeUserObject(userId, user);
        }
        this.deleteObject(this.makeByAliasId(id));
    }

    protected Collection<String> loadAliasesForUser(String userId) throws IamSvcException, IamIdentityDoesNotExist {
        JSONObject user = this.loadUserObject(userId);
        if (user == null) {
            throw new IamIdentityDoesNotExist(userId);
        }
        JSONArray userAliases = user.optJSONArray("aliases");
        if (userAliases != null) {
            return JsonVisitor.arrayToList((JSONArray)userAliases);
        }
        return new LinkedList<String>();
    }

    protected void storeInvalidJwtToken(String token) throws IamSvcException {
        this.storeObject(this.makeJwtTokenId(token), new JSONObject());
    }

    protected boolean isInvalidJwtToken(String token) throws IamSvcException {
        return null != this.loadObject(this.makeJwtTokenId(token));
    }

    private void ensurePathExists(String ... pathParts) throws IamSvcException {
        String path = this.concatPathParts(pathParts);
        boolean exists = false;
        try {
            exists = null != this.fZk.checkExists().forPath(path);
        }
        catch (Exception x) {
            throw new IamSvcException((Throwable)x);
        }
        if (!exists) {
            this.storeObject(path, new JSONObject());
        }
    }

    public static abstract class Builder<I extends CommonJsonIdentity, G extends CommonJsonGroup> {
        private String fZkConnectionString;
        private String prefix;
        private CommonJsonDb.AclFactory fAclFactory;
        private JwtProducer fJwtProducer = null;
        private LinkedList<JwtValidator> fJwtValidators = new LinkedList();

        public Builder<I, G> connectingTo(String key) {
            this.fZkConnectionString = key;
            return this;
        }

        public Builder<I, G> withPathPrefix(String pathPrefix) {
            this.prefix = pathPrefix;
            return this;
        }

        public Builder<I, G> usingAclFactory(CommonJsonDb.AclFactory af) {
            this.fAclFactory = af;
            return this;
        }

        public Builder<I, G> withJwtProducer(JwtProducer p) {
            this.fJwtProducer = p;
            return this;
        }

        public Builder<I, G> addJwtValidator(JwtValidator v) {
            this.fJwtValidators.add(v);
            return this;
        }

        public abstract ZkIamDb<I, G> build() throws IamSvcException;
    }
}

