/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.tools;

import io.continual.builder.Builder;
import io.continual.iam.IamDb;
import io.continual.iam.access.AccessControlList;
import io.continual.iam.access.Resource;
import io.continual.iam.exceptions.IamBadRequestException;
import io.continual.iam.exceptions.IamGroupDoesNotExist;
import io.continual.iam.exceptions.IamGroupExists;
import io.continual.iam.exceptions.IamIdentityDoesNotExist;
import io.continual.iam.exceptions.IamIdentityExists;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.ApiKey;
import io.continual.iam.identity.Group;
import io.continual.iam.identity.Identity;
import io.continual.iam.tools.IamDbBackup;
import io.continual.util.console.CmdLinePrefs;
import io.continual.util.console.ConsoleProgram;
import io.continual.util.console.shell.Command;
import io.continual.util.console.shell.CommandList;
import io.continual.util.console.shell.ConsoleLooper;
import io.continual.util.console.shell.SimpleCommand;
import io.continual.util.console.shell.StdCommandList;
import io.continual.util.nv.NvReadable;
import io.continual.util.time.Clock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;

public abstract class IamDbTool<I extends Identity, G extends Group>
extends ConsoleProgram {
    private IamDb<I, G> fDb = null;

    protected ConsoleProgram.Looper init(NvReadable p, CmdLinePrefs cmdLine) throws NvReadable.MissingReqdSettingException, NvReadable.InvalidSettingValueException, ConsoleProgram.StartupFailureException {
        return new ConsoleLooper(new String[]{"iam db tool"}, "> ", ". ", (CommandList)new commandSet());
    }

    protected abstract IamDb<I, G> createDb(Vector<String> var1, PrintStream var2) throws IamSvcException, Builder.BuildFailure;

    public abstract class IamDbCmd
    extends SimpleCommand {
        private final boolean fReqDb;

        protected IamDbCmd(String name, boolean reqDb) {
            super(name);
            this.fReqDb = reqDb;
        }

        protected final ConsoleLooper.InputResult execute(HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
            IamDb<?, ?> db = this.getDb(workspace);
            if (this.fReqDb && db == null) {
                outTo.println("Use connect to connect to an IAM DB");
                return ConsoleLooper.InputResult.kReady;
            }
            Vector args = p.getFileArguments();
            this.execute(db, args, workspace, p, outTo);
            return ConsoleLooper.InputResult.kReady;
        }

        protected abstract void execute(IamDb<?, ?> var1, Vector<String> var2, HashMap<String, Object> var3, CmdLinePrefs var4, PrintStream var5) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException;

        private IamDb<?, ?> getDb(HashMap<String, Object> workspace) {
            Object o = workspace.get("iamDb");
            if (o instanceof IamDb) {
                return (IamDb)o;
            }
            return null;
        }
    }

    private class commandSet
    extends StdCommandList {
        public commandSet() {
            this.registerCommand((Command)new IamDbCmd("connect", false){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (IamDbTool.this.fDb != null) {
                        IamDbTool.this.fDb.close();
                    }
                    try {
                        IamDbTool.this.fDb = IamDbTool.this.createDb(args, outTo);
                        workspace.put("iamDb", IamDbTool.this.fDb);
                    }
                    catch (Builder.BuildFailure | IamSvcException e) {
                        outTo.println("Problem connecting to IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("createUser", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 1) {
                        outTo.println("usage: createUser <userId>");
                        return;
                    }
                    try {
                        IamDbTool.this.fDb.createUser(args.elementAt(0));
                        outTo.println("ok.");
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                    catch (IamIdentityExists e) {
                        outTo.println("The identity already exists.");
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("enableUser", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 1) {
                        outTo.println("usage: enableUser <userId>");
                        return;
                    }
                    try {
                        Object i = IamDbTool.this.fDb.loadUser(args.elementAt(0));
                        if (i != null) {
                            i.enable(true);
                            outTo.println("ok.");
                        } else {
                            outTo.println("no such user.");
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("disableUser", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 1) {
                        outTo.println("usage: disableUser <userId>");
                        return;
                    }
                    try {
                        Object i = IamDbTool.this.fDb.loadUser(args.elementAt(0));
                        if (i != null) {
                            i.enable(false);
                            outTo.println("ok.");
                        } else {
                            outTo.println("no such user.");
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("createGroup", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() < 1 || args.size() > 2) {
                        outTo.println("usage: createGroup [<groupId>] <groupName>");
                        return;
                    }
                    try {
                        if (args.size() == 1) {
                            Object g = IamDbTool.this.fDb.createGroup(args.elementAt(0));
                            outTo.println("Group " + g.getId() + " created.");
                        } else {
                            Object g = IamDbTool.this.fDb.createGroup(args.elementAt(0), args.elementAt(1));
                            outTo.println("Group " + g.getId() + " created.");
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                    catch (IamGroupExists e) {
                        outTo.println("Group exists: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("addToGroup", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 2) {
                        outTo.println("usage: addToGroup <userId> <groupId>");
                        return;
                    }
                    try {
                        IamDbTool.this.fDb.addUserToGroup(args.elementAt(1), args.elementAt(0));
                        outTo.println("ok.");
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                    catch (IamGroupDoesNotExist | IamIdentityDoesNotExist e) {
                        outTo.println(e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("removeFromGroup", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 2) {
                        outTo.println("usage: removeFromGroup <userId> <groupId>");
                        return;
                    }
                    try {
                        IamDbTool.this.fDb.removeUserFromGroup(args.elementAt(1), args.elementAt(0));
                        outTo.println("ok.");
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                    catch (IamGroupDoesNotExist | IamIdentityDoesNotExist e) {
                        outTo.println(e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("listGroups", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 1) {
                        outTo.println("usage: listGroups <userId>");
                        return;
                    }
                    try {
                        for (String user : IamDbTool.this.fDb.getUsersGroups(args.elementAt(0))) {
                            outTo.println(user);
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                    catch (IamIdentityDoesNotExist e) {
                        outTo.println(e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("listUsers", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 0) {
                        outTo.println("usage: listUsers");
                        return;
                    }
                    try {
                        for (String user : IamDbTool.this.fDb.getAllUsers()) {
                            outTo.println(user);
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("findUsers", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 1) {
                        outTo.println("usage: findUsers <startingWith>");
                        return;
                    }
                    try {
                        for (String user : IamDbTool.this.fDb.findUsers(args.elementAt(0))) {
                            outTo.println(user);
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("setData", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 3) {
                        outTo.println("usage: setData <userId> <name> <value>");
                        return;
                    }
                    try {
                        Object i = IamDbTool.this.fDb.loadUser(args.elementAt(0));
                        if (i != null) {
                            i.putUserData(args.elementAt(1), args.elementAt(2));
                            outTo.println("ok.");
                        } else {
                            outTo.println("Couldn't find user.");
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("setGroupData", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 3) {
                        outTo.println("usage: setGroupData <groupId> <name> <value>");
                        return;
                    }
                    try {
                        Object i = IamDbTool.this.fDb.loadGroup(args.elementAt(0));
                        if (i != null) {
                            i.putUserData(args.elementAt(1), args.elementAt(2));
                            outTo.println("ok.");
                        } else {
                            outTo.println("Couldn't find group.");
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("clearData", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 2) {
                        outTo.println("usage: clearData <userId> <name>");
                        return;
                    }
                    try {
                        Object i = IamDbTool.this.fDb.loadUser(args.elementAt(0));
                        if (i != null) {
                            i.removeUserData(args.elementAt(1));
                            outTo.println("ok.");
                        } else {
                            outTo.println("Couldn't find user.");
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("setPassword", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 2) {
                        outTo.println("usage: setPassword <userId> <password>");
                        return;
                    }
                    try {
                        Object i = IamDbTool.this.fDb.loadUser(args.elementAt(0));
                        if (i != null) {
                            i.setPassword(args.elementAt(1));
                            outTo.println("ok.");
                        } else {
                            outTo.println("Couldn't find user.");
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("createApiKey", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 1) {
                        outTo.println("usage: createApiKey <userId>");
                        return;
                    }
                    try {
                        Object i = IamDbTool.this.fDb.loadUser(args.elementAt(0));
                        if (i != null) {
                            ApiKey key = i.createApiKey();
                            outTo.println("   key: " + key.getKey());
                            outTo.println("secret: " + key.getSecret());
                        } else {
                            outTo.println("Couldn't find user.");
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("restoreApiKey", true){

                @Override
                protected void execute(IamDb<?, ?> db, final Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    final long nowMs = Clock.now();
                    if (args.size() != 3) {
                        outTo.println("usage: restoreApiKey <userId> <apiKey> <apiSecret>");
                        return;
                    }
                    try {
                        IamDbTool.this.fDb.restoreApiKey(new ApiKey(){

                            @Override
                            public String getUserId() {
                                return (String)args.elementAt(0);
                            }

                            @Override
                            public String getKey() {
                                return (String)args.elementAt(1);
                            }

                            @Override
                            public String getSecret() {
                                return (String)args.elementAt(2);
                            }

                            @Override
                            public long getCreationTimestamp() {
                                return nowMs;
                            }
                        });
                    }
                    catch (IamBadRequestException | IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("getUser", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 1) {
                        outTo.println("usage: getUser <userId>");
                        return;
                    }
                    try {
                        Object i = IamDbTool.this.fDb.loadUser(args.elementAt(0));
                        if (i != null) {
                            outTo.println("Enabled: " + i.isEnabled());
                            outTo.println();
                            outTo.println("API Keys");
                            for (String apiKey : i.loadApiKeysForUser()) {
                                outTo.println("\t" + apiKey);
                            }
                            outTo.println();
                            outTo.println("Data");
                            Map<String, String> data = i.getAllUserData();
                            for (Map.Entry<String, String> e : data.entrySet()) {
                                outTo.println("\t" + e.getKey() + ": " + e.getValue());
                            }
                            outTo.println();
                            outTo.println("Groups");
                            for (String group : i.getGroupIds()) {
                                outTo.println("\t" + group);
                            }
                            outTo.println();
                        } else {
                            outTo.println("Couldn't find user.");
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("getGroup", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 1) {
                        outTo.println("usage: getGroup <groupId>");
                        return;
                    }
                    try {
                        Object i = IamDbTool.this.fDb.loadGroup(args.elementAt(0));
                        if (i != null) {
                            outTo.println("Data");
                            Map<String, String> data = i.getAllUserData();
                            for (Map.Entry<String, String> e : data.entrySet()) {
                                outTo.println("\t" + e.getKey() + ": " + e.getValue());
                            }
                            outTo.println("Users");
                            for (String group : i.getMembers()) {
                                outTo.println("\t" + group);
                            }
                        } else {
                            outTo.println("Couldn't find user.");
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("listAcl", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 1) {
                        outTo.println("usage: listAcl <resourceId>");
                        return;
                    }
                    try {
                        final String resName = args.elementAt(0);
                        AccessControlList acl = IamDbTool.this.fDb.getAclFor(new Resource(){

                            @Override
                            public String getId() {
                                return resName;
                            }
                        });
                        if (acl == null) {
                            outTo.println("No ACL for " + resName);
                        } else {
                            outTo.println(acl.asJson().toString(4));
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("grant", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 3) {
                        outTo.println("usage: grant <resource> <userOrGroupId> <operation>");
                        return;
                    }
                    final String resource = args.elementAt(0);
                    String userOrGroup = args.elementAt(1);
                    String access = args.elementAt(2);
                    try {
                        AccessControlList acl = IamDbTool.this.fDb.getAclFor(new Resource(){

                            @Override
                            public String getId() {
                                return resource;
                            }
                        });
                        Object i = IamDbTool.this.fDb.loadUser(userOrGroup);
                        if (i != null) {
                            acl.permit(userOrGroup, access);
                        } else {
                            Object g = IamDbTool.this.fDb.loadGroup(userOrGroup);
                            if (g != null) {
                                acl.permit(userOrGroup, access);
                            } else {
                                outTo.println("No user or group named '" + userOrGroup + "' was found.");
                            }
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("revoke", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 3) {
                        outTo.println("usage: revoke <resource> <userOrGroupId> <operation>");
                        return;
                    }
                    final String resource = args.elementAt(0);
                    String userOrGroup = args.elementAt(1);
                    String access = args.elementAt(2);
                    try {
                        AccessControlList acl = IamDbTool.this.fDb.getAclFor(new Resource(){

                            @Override
                            public String getId() {
                                return resource;
                            }
                        });
                        Object i = IamDbTool.this.fDb.loadUser(userOrGroup);
                        if (i != null) {
                            acl.clear(userOrGroup, access);
                        } else {
                            Object g = IamDbTool.this.fDb.loadGroup(userOrGroup);
                            if (g != null) {
                                acl.clear(userOrGroup, access);
                            } else {
                                outTo.println("No user or group named '" + userOrGroup + "' was found.");
                            }
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("sweepExpiredTags", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 0) {
                        outTo.println("usage: sweepExpiredKeys");
                        return;
                    }
                    try {
                        IamDbTool.this.fDb.sweepExpiredTags();
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("report", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 0) {
                        outTo.println("usage: report");
                        return;
                    }
                    try {
                        Map users = IamDbTool.this.fDb.loadAllUsers();
                        LinkedList<String> userList = new LinkedList<String>();
                        userList.addAll(users.keySet());
                        Collections.sort(userList);
                        outTo.println("userId,acctId,enabled");
                        for (String userId : userList) {
                            Identity user = (Identity)users.get(userId);
                            if (user == null) {
                                outTo.println("WARN: " + userId + " has null user record");
                                continue;
                            }
                            String groupId = user.getUserData("acctId");
                            StringBuilder sb = new StringBuilder();
                            sb.append(userId).append(",").append(groupId).append(",").append(user.isEnabled());
                            outTo.println(sb.toString());
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("canUser", true){

                @Override
                protected void execute(IamDb<?, ?> db, final Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 3) {
                        outTo.println("usage: <user> <resource> <op>");
                        return;
                    }
                    try {
                        boolean response = IamDbTool.this.fDb.canUser(args.elementAt(0), new Resource(){

                            @Override
                            public String getId() {
                                return (String)args.elementAt(1);
                            }
                        }, args.elementAt(2));
                        outTo.println(response);
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("listGroup", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 1) {
                        outTo.println("usage: listGroup <groupId>");
                        return;
                    }
                    try {
                        for (String userId : IamDbTool.this.fDb.getUsersInGroup(args.elementAt(0))) {
                            outTo.println(userId);
                        }
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                    catch (IamGroupDoesNotExist e) {
                        outTo.println("Group does not exist: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("addAlias", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 2) {
                        outTo.println("usage: addAlias <userId> <alias>");
                        return;
                    }
                    try {
                        IamDbTool.this.fDb.addAlias(args.elementAt(0), args.elementAt(1));
                    }
                    catch (IamSvcException e) {
                        outTo.println("Service problem: " + e.getMessage());
                    }
                    catch (IamBadRequestException e) {
                        outTo.println("Request problem: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("removeAlias", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 1) {
                        outTo.println("usage: removeAlias <alias>");
                        return;
                    }
                    try {
                        IamDbTool.this.fDb.removeAlias(args.elementAt(0));
                    }
                    catch (IamSvcException e) {
                        outTo.println("Service problem: " + e.getMessage());
                    }
                    catch (IamBadRequestException e) {
                        outTo.println("Request problem: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("backup", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 1) {
                        outTo.println("usage: backup <toFile>");
                        return;
                    }
                    try (FileOutputStream fos = new FileOutputStream(new File(args.elementAt(0)));){
                        new IamDbBackup(IamDbTool.this.fDb).backupTo(fos);
                    }
                    catch (IOException e) {
                        outTo.println("Couldn't write file: " + e.getMessage());
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("restore", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() != 1) {
                        outTo.println("usage: restore <fromFile>");
                        return;
                    }
                    try (FileInputStream fis = new FileInputStream(new File(args.elementAt(0)));){
                        new IamDbBackup(IamDbTool.this.fDb).restoreFrom(fis);
                    }
                    catch (IOException | JSONException e) {
                        outTo.println("Couldn't read file: " + e.getMessage());
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
            this.registerCommand((Command)new IamDbCmd("createToken", true){

                @Override
                protected void execute(IamDb<?, ?> db, Vector<String> args, HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    if (args.size() < 1 || args.size() > 2) {
                        outTo.println("usage: createToken <user> [<durationHrs>]");
                        return;
                    }
                    long duration = args.size() == 2 ? Long.parseLong(args.elementAt(1)) : 0L;
                    try {
                        Object user = IamDbTool.this.fDb.loadUser(args.elementAt(0));
                        if (user == null) {
                            outTo.println("User " + args.elementAt(0) + " not found.");
                            return;
                        }
                        String token = IamDbTool.this.fDb.createJwtToken((Identity)user, duration, TimeUnit.HOURS);
                        outTo.println(token);
                    }
                    catch (JSONException e) {
                        outTo.println("Couldn't read file: " + e.getMessage());
                    }
                    catch (IamSvcException e) {
                        outTo.println("Problem with IAM DB: " + e.getMessage());
                    }
                }
            });
        }
    }
}

