/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl.common;

import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Group;
import io.continual.iam.impl.common.CommonJsonDb;
import io.continual.iam.impl.common.CommonJsonObject;
import io.continual.util.data.json.JsonVisitor;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommonJsonGroup
extends CommonJsonObject
implements Group {
    private final String fId;
    private final CommonJsonDb<?, ?> fDb;
    private JSONObject fObj;
    private final TreeSet<String> fMembers;

    public static JSONObject initializeGroup(String name) {
        return new JSONObject().put("name", (Object)name);
    }

    public CommonJsonGroup(CommonJsonDb<?, ?> db, String id, JSONObject group) {
        this.fDb = db;
        this.fId = id;
        this.fObj = group;
        this.fMembers = new TreeSet();
        this.parse();
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fObj.optString("name");
    }

    @Override
    public boolean isMember(String userId) throws IamSvcException {
        return this.fMembers.contains(userId);
    }

    @Override
    public Set<String> getMembers() throws IamSvcException {
        return new TreeSet<String>((SortedSet<String>)this.fMembers);
    }

    public void addUser(String userId) throws IamSvcException {
        if (this.fMembers.add(userId)) {
            this.pack();
            this.store();
        }
    }

    public void removeUser(String userId) throws IamSvcException {
        if (this.fMembers.remove(userId)) {
            this.pack();
            this.store();
        }
    }

    @Override
    public void reload() throws IamSvcException {
        this.fObj = this.fDb.loadGroupObject(this.getId());
        this.parse();
    }

    @Override
    protected JSONObject getDataRecord() {
        return this.fObj;
    }

    @Override
    protected void store() throws IamSvcException {
        this.fDb.storeGroupObject(this.getId(), this.getDataRecord());
    }

    private void parse() {
        this.fMembers.clear();
        this.fMembers.addAll(JsonVisitor.arrayToList((JSONArray)this.fObj.optJSONArray("members")));
    }

    private void pack() {
        this.fObj.put("members", (Object)JsonVisitor.collectionToArray(this.fMembers));
    }
}

