/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.access;

import io.continual.iam.access.AccessControlList;
import io.continual.iam.access.AccessException;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;

public class AclChecker {
    private AccessControlList fAcl = null;
    private Identity fUser = null;
    private String fOp = null;
    private String fResource = "";

    public AclChecker forUser(Identity user) {
        this.fUser = user;
        return this;
    }

    public AclChecker reading() {
        return this.performing("read");
    }

    public AclChecker updating() {
        return this.performing("update");
    }

    public AclChecker creating() {
        return this.performing("create");
    }

    public AclChecker deleting() {
        return this.performing("delete");
    }

    public AclChecker performing(String op) {
        this.fOp = op;
        return this;
    }

    public AclChecker onResource(String resource) {
        this.fResource = resource;
        return this;
    }

    public AclChecker controlledByAcl(AccessControlList acl) {
        this.fAcl = acl;
        return this;
    }

    public void check() throws AccessException, IamSvcException {
        if (this.fUser == null) {
            throw new AccessException("No user provided.");
        }
        if (this.fAcl == null) {
            throw new AccessException("No ACL provided.");
        }
        if (this.fOp == null) {
            throw new AccessException("No operation provided.");
        }
        if (!this.fAcl.canUser(this.fUser, this.fOp.toString())) {
            throw new AccessException(this.fUser.getId() + " may not " + this.fOp.toString().toLowerCase() + " " + this.fResource);
        }
    }
}

