/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.access;

import io.continual.util.data.json.JsonVisitor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AccessControlEntry {
    public static final String kAnyUser = "*";
    public static final String kOwner = "~owner~";
    private final String fWho;
    private final TreeSet<String> fOperations;
    private final Access fPermission;

    public AccessControlEntry(String userOrGroupId, Access p, String operation) {
        this(userOrGroupId, p, new String[]{operation});
    }

    public AccessControlEntry(String userOrGroupId, Access p, String[] operations) {
        this.fWho = userOrGroupId;
        this.fOperations = new TreeSet();
        this.fPermission = p;
        for (String op : operations) {
            this.fOperations.add(op);
        }
    }

    public AccessControlEntry(String userOrGroupId, Access p, Collection<String> a) {
        this.fWho = userOrGroupId;
        this.fPermission = p;
        this.fOperations = new TreeSet<String>(a);
    }

    public AccessControlEntry clone() {
        return new AccessControlEntry(this.fWho, this.fPermission, this.fOperations);
    }

    public Access check(String userId, Set<String> groups, boolean isOwner, String op) {
        if (this.fWho.equals(kAnyUser) || this.fWho.equals(userId) || groups.contains(this.fWho) || isOwner && this.fWho.equals(kOwner)) {
            for (String a : this.fOperations) {
                if (!a.equalsIgnoreCase(op)) continue;
                return this.fPermission;
            }
        }
        return null;
    }

    public String getSubject() {
        return this.fWho;
    }

    public Access getPermission() {
        return this.fPermission;
    }

    public Set<String> getOperationSet() {
        return new TreeSet<String>((SortedSet<String>)this.fOperations);
    }

    public String[] getOperations() {
        int i = 0;
        String[] result = new String[this.fOperations.size()];
        for (String op : this.getOperationSet()) {
            result[i++] = op;
        }
        return result;
    }

    public boolean removeOperation(String op) {
        return this.fOperations.remove(op);
    }

    public int getOperationCount() {
        return this.fOperations.size();
    }

    public String toString() {
        return this.serialize().toString();
    }

    public JSONObject serialize() {
        JSONArray ops = new JSONArray();
        for (String op : this.fOperations) {
            ops.put((Object)op);
        }
        return new JSONObject().put("who", (Object)this.fWho).put("access", (Object)this.fPermission.toString()).put("operations", (Object)ops);
    }

    public static AccessControlEntry deserialize(JSONObject o) {
        final LinkedList ops = new LinkedList();
        JsonVisitor.forEachElement((JSONArray)o.getJSONArray("operations"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<String, JSONException>(){

            public boolean visit(String op) throws JSONException {
                ops.add(op);
                return true;
            }
        });
        return new AccessControlEntry(o.getString("who"), Access.valueOf(o.getString("access")), ops.toArray(new String[ops.size()]));
    }

    public static enum Access {
        PERMIT,
        DENY;

    }
}

