/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.access;

import io.continual.iam.access.AccessControlEntry;
import io.continual.iam.access.AclUpdateListener;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.data.json.JsonVisitor;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class AccessControlList {
    public static final String CREATE = "create";
    public static final String READ = "read";
    public static final String UPDATE = "update";
    public static final String DELETE = "delete";
    private String fOwner;
    private final LinkedList<AccessControlEntry> fEntries;
    private final AclUpdateListener fListener;

    public static Builder builder() {
        return new Builder();
    }

    public AccessControlList() {
        this((AclUpdateListener)null);
    }

    public AccessControlList(AclUpdateListener listener) {
        this.fOwner = null;
        this.fEntries = new LinkedList();
        this.fListener = listener;
    }

    public String getOwner() {
        return this.fOwner;
    }

    public AccessControlList setOwner(String userOrGroupId) {
        this.fOwner = userOrGroupId;
        if (this.fListener != null) {
            this.fListener.onAclUpdate(this);
        }
        return this;
    }

    public AccessControlList permit(String userOrGroupId, String ... ops) {
        return this.addAclEntry(new AccessControlEntry(userOrGroupId, AccessControlEntry.Access.PERMIT, ops));
    }

    public AccessControlList deny(String userOrGroupId, String ... ops) {
        return this.addAclEntry(new AccessControlEntry(userOrGroupId, AccessControlEntry.Access.DENY, ops));
    }

    public AccessControlList clear(String userOrGroupId, String ... ops) {
        boolean changed = false;
        LinkedList<AccessControlEntry> removals = new LinkedList<AccessControlEntry>();
        for (AccessControlEntry e : this.fEntries) {
            if (!e.getSubject().equals(userOrGroupId)) continue;
            for (String op : ops) {
                boolean change = e.removeOperation(op);
                changed = changed || change;
            }
            if (e.getOperationCount() != 0) continue;
            removals.add(e);
        }
        for (AccessControlEntry e : removals) {
            boolean change = this.fEntries.remove(e);
            changed = changed || change;
        }
        if (changed && this.fListener != null) {
            this.fListener.onAclUpdate(this);
        }
        return this;
    }

    public AccessControlList clear() {
        this.fEntries.clear();
        if (this.fListener != null) {
            this.fListener.onAclUpdate(this);
        }
        return this;
    }

    public List<AccessControlEntry> getEntries() {
        LinkedList<AccessControlEntry> result = new LinkedList<AccessControlEntry>();
        for (AccessControlEntry e : this.fEntries) {
            result.add(e.clone());
        }
        return result;
    }

    public boolean canUser(Identity user, String op) throws IamSvcException {
        if (user == null) {
            return this.canUser(null, new TreeSet<String>(), op);
        }
        return this.canUser(user.getId(), user.getGroupIds(), op);
    }

    public boolean canUser(String userId, Set<String> groups, String op) {
        boolean isOwner = userId != null && userId.equals(this.getOwner());
        for (AccessControlEntry e : this.getEntries()) {
            AccessControlEntry.Access p = e.check(userId, groups, isOwner, op);
            if (p == null) continue;
            if (p.equals((Object)AccessControlEntry.Access.DENY)) {
                return false;
            }
            if (!p.equals((Object)AccessControlEntry.Access.PERMIT)) continue;
            return true;
        }
        return false;
    }

    public AccessControlList addAclEntry(AccessControlEntry acle) {
        this.fEntries.add(acle);
        if (this.fListener != null) {
            this.fListener.onAclUpdate(this);
        }
        return this;
    }

    public String toString() {
        return this.serialize();
    }

    public JSONObject asJson() {
        JSONArray entries = new JSONArray();
        for (AccessControlEntry e : this.getEntries()) {
            entries.put((Object)e.serialize());
        }
        return new JSONObject().put("owner", (Object)this.fOwner).put("entries", (Object)entries);
    }

    public String serialize() {
        return this.asJson().toString();
    }

    public static AccessControlList initialize(AclUpdateListener listener) {
        return new AccessControlList(listener);
    }

    public static AccessControlList deserialize(String s, AclUpdateListener listener) {
        JSONObject o = new JSONObject((JSONTokener)new CommentedJsonTokener(s));
        return AccessControlList.deserialize(o, listener);
    }

    public static AccessControlList deserialize(JSONObject o, AclUpdateListener listener) {
        if (o == null) {
            return AccessControlList.initialize(listener);
        }
        final AccessControlList acl = new AccessControlList(listener);
        acl.fOwner = o.optString("owner", null);
        JsonVisitor.forEachElement((JSONArray)o.optJSONArray("entries"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, JSONException>(){

            public boolean visit(JSONObject t) throws JSONException {
                AccessControlEntry e = AccessControlEntry.deserialize(t);
                acl.fEntries.add(e);
                return true;
            }
        });
        return acl;
    }

    public AclUpdateListener getListener() {
        return this.fListener;
    }

    private AccessControlList(Builder b) {
        this.fOwner = b.fOwner;
        this.fListener = b.fListener;
        this.fEntries = new LinkedList();
        this.fEntries.addAll(b.fAces);
    }

    public static class Builder {
        private String fOwner = null;
        private LinkedList<AccessControlEntry> fAces = new LinkedList();
        private AclUpdateListener fListener = null;

        public Builder ownedBy(String userOrGroupId) {
            this.fOwner = userOrGroupId;
            return this;
        }

        public Builder withEntry(AccessControlEntry ace) {
            this.fAces.add(ace);
            return this;
        }

        public Builder withListener(AclUpdateListener l) {
            this.fListener = l;
            return this;
        }

        public AccessControlList build() {
            return new AccessControlList(this);
        }
    }
}

