/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl.common;

import io.continual.iam.IamDb;
import io.continual.iam.access.AccessControlList;
import io.continual.iam.access.AclUpdateListener;
import io.continual.iam.access.ProtectedResource;
import io.continual.iam.access.Resource;
import io.continual.iam.credentials.ApiKeyCredential;
import io.continual.iam.credentials.JwtCredential;
import io.continual.iam.credentials.UsernamePasswordCredential;
import io.continual.iam.exceptions.IamBadRequestException;
import io.continual.iam.exceptions.IamGroupDoesNotExist;
import io.continual.iam.exceptions.IamGroupExists;
import io.continual.iam.exceptions.IamIdentityDoesNotExist;
import io.continual.iam.exceptions.IamIdentityExists;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.ApiKey;
import io.continual.iam.identity.Group;
import io.continual.iam.identity.Identity;
import io.continual.iam.identity.JwtValidator;
import io.continual.iam.impl.common.CommonJsonGroup;
import io.continual.iam.impl.common.CommonJsonIdentity;
import io.continual.iam.impl.common.jwt.JwtProducer;
import io.continual.metrics.MetricsCatalog;
import io.continual.util.data.OneWayHasher;
import io.continual.util.data.Sha1HmacSigner;
import io.continual.util.data.UniqueStringGenerator;
import io.continual.util.time.Clock;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonJsonDb<I extends CommonJsonIdentity, G extends CommonJsonGroup>
implements IamDb<I, G> {
    public static final String kTagId = "tagId";
    public static final String kUserId = "userId";
    public static final String kTagType = "tagType";
    public static final String kExpireEpoch = "expireEpoch";
    public static final String kSecret = "secret";
    public static final String kAlias = "alias";
    public static final String kEnabled = "enabled";
    public static final String kPasswordBlock = "password";
    public static final String kPasswordSalt = "salt";
    public static final String kPasswordHash = "hash";
    public static final String kTagType_PasswordReset = "passwordReset";
    private static final String kKeyChars = "ABCDEFGHJIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private final AclFactory fAclFactory;
    private final JwtProducer fJwtTokenFactory;
    private final LinkedList<JwtValidator> fJwtValidators;
    static final int kSaltChars = 64;
    private static final Logger log = LoggerFactory.getLogger(CommonJsonDb.class);
    private static final boolean skAuthLogging = true;

    public void populateMetrics(MetricsCatalog metrics) {
    }

    @Override
    public boolean userExists(String userId) throws IamSvcException {
        return null != this.loadUser(userId);
    }

    @Override
    public boolean userOrAliasExists(String userIdOrAlias) throws IamSvcException {
        return this.userExists(userIdOrAlias) || this.aliasExists(userIdOrAlias);
    }

    protected boolean aliasExists(String userId) throws IamSvcException {
        return null != this.loadAliasObject(userId);
    }

    @Override
    public I loadUser(String userId) throws IamSvcException {
        JSONObject user = this.loadUserObject(userId);
        if (user != null) {
            return this.instantiateIdentity(userId, user);
        }
        return null;
    }

    @Override
    public I loadUserOrAlias(String userIdOrAlias) throws IamSvcException {
        Identity user = this.loadUser(userIdOrAlias);
        if (user != null) {
            return (I)user;
        }
        JSONObject alias = this.loadAliasObject(userIdOrAlias);
        if (alias != null) {
            String userId = alias.getString(kUserId);
            if (userId != null) {
                return (I)this.loadUser(userId);
            }
            log.warn("Alias [" + userIdOrAlias + "] record exists but doesn't contain " + kUserId + ".");
        }
        return null;
    }

    @Override
    public I createUser(String userId) throws IamSvcException, IamIdentityExists {
        if (this.userExists(userId)) {
            throw new IamIdentityExists(userId);
        }
        this.storeUserObject(userId, this.createNewUser(userId));
        return (I)this.loadUser(userId);
    }

    @Override
    public I createAnonymousUser() throws IamSvcException {
        try {
            String anonId = UniqueStringGenerator.create((String)"continual iam json db");
            return (I)this.createUser(anonId);
        }
        catch (IamIdentityExists e) {
            throw new IamSvcException("anonymous user exists... " + e.getMessage());
        }
    }

    @Override
    public void deleteUser(String userId) throws IamSvcException {
        this.deleteUserObject(userId);
    }

    @Override
    public boolean completePasswordReset(String tagId, String newPassword) throws IamSvcException {
        String userId = this.getUserIdForTag(tagId);
        if (userId != null) {
            Identity i = this.loadUser(userId);
            if (i != null) {
                ((CommonJsonIdentity)i).setPassword(newPassword);
                this.deleteTagObject(tagId, userId, kTagType_PasswordReset);
                return true;
            }
            CommonJsonDb.authLog("Ignoring password reset completion on tag " + tagId + " for user [" + userId + "], who does not exist.");
        }
        return false;
    }

    @Override
    public ApiKey loadApiKeyRecord(String apiKey) throws IamSvcException {
        JSONObject record = this.loadApiKeyObject(apiKey);
        if (record != null) {
            return this.instantiateApiKey(apiKey, record);
        }
        return null;
    }

    @Override
    public String createJwtToken(Identity ii) throws IamSvcException {
        if (this.fJwtTokenFactory == null) {
            throw new IamSvcException("This identity manager does not have a JWT token factory.");
        }
        return this.fJwtTokenFactory.createJwtToken(ii);
    }

    @Override
    public I authenticate(ApiKeyCredential akc) throws IamSvcException {
        String apiKey = akc.getApiKey();
        ApiKey key = this.loadApiKeyRecord(apiKey);
        if (key != null) {
            String expectedSignature = Sha1HmacSigner.sign((String)akc.getContent(), (String)key.getSecret());
            CommonJsonDb.authLog("expecting [" + expectedSignature + "]; received [" + akc.getSignature() + "]. signed content [" + akc.getContent() + "].");
            if (expectedSignature.equals(akc.getSignature())) {
                CommonJsonDb.authLog(key.getUserId() + " authenticated via API key " + apiKey);
                Identity result = this.loadUser(key.getUserId());
                ((CommonJsonIdentity)result).setApiKeyUsedForAuth(apiKey);
                return (I)result;
            }
        }
        CommonJsonDb.authLog(akc.getApiKey() + " authentication failed");
        return null;
    }

    @Override
    public I authenticate(JwtCredential jwt) throws IamSvcException {
        for (JwtValidator v : this.fJwtValidators) {
            if (!v.validate(jwt)) continue;
            return (I)this.loadUser(jwt.getSubject());
        }
        return null;
    }

    @Override
    public void invalidateJwtToken(String token) throws IamSvcException {
        this.storeInvalidJwtToken(token);
    }

    @Override
    public I authenticate(UsernamePasswordCredential upc) throws IamSvcException {
        Identity user = this.loadUserOrAlias(upc.getUsername());
        if (user == null) {
            CommonJsonDb.authLog("No such user " + upc.getUsername());
            return null;
        }
        if (!((CommonJsonIdentity)user).isEnabled()) {
            CommonJsonDb.authLog("User " + upc.getUsername() + " is disabled.");
            return null;
        }
        String attemptedPassword = upc.getPassword();
        if (attemptedPassword == null) {
            CommonJsonDb.authLog("User " + upc.getUsername() + " auth attempt without password.");
            return null;
        }
        String salt = ((CommonJsonIdentity)user).getPasswordSalt();
        if (salt == null || salt.length() == 0) {
            CommonJsonDb.authLog("User " + upc.getUsername() + " does not have a password.");
            return null;
        }
        String hashedPassword = OneWayHasher.pbkdf2HashToString((String)attemptedPassword, (String)salt);
        String hash = ((CommonJsonIdentity)user).getPasswordHash();
        if (hash == null || !hash.equals(hashedPassword)) {
            CommonJsonDb.authLog("Password for " + upc.getUsername() + " doesn't match.");
            return null;
        }
        return (I)user;
    }

    @Override
    public G createGroup(String groupDesc) throws IamSvcException {
        String groupId = UUID.randomUUID().toString();
        try {
            return (G)this.createGroup(groupId, groupDesc);
        }
        catch (IamGroupExists e) {
            log.warn("UUID created randomly conflicted with an exist group name.");
            return (G)this.loadGroup(groupId);
        }
    }

    @Override
    public G createGroup(String groupId, String groupDesc) throws IamGroupExists, IamSvcException {
        Group group = this.loadGroup(groupId);
        if (group != null) {
            throw new IamGroupExists(groupId);
        }
        JSONObject o = this.createNewGroup(groupId, groupDesc);
        this.storeGroupObject(groupId, o);
        return (G)this.loadGroup(groupId);
    }

    @Override
    public void addUserToGroup(String groupId, String userId) throws IamIdentityDoesNotExist, IamSvcException, IamGroupDoesNotExist {
        Identity user = this.loadUserOrAlias(userId);
        if (user == null) {
            throw new IamIdentityDoesNotExist(userId);
        }
        Group group = this.loadGroup(groupId);
        if (group == null) {
            throw new IamGroupDoesNotExist(groupId);
        }
        ((CommonJsonGroup)group).addUser(userId);
        ((CommonJsonIdentity)user).addGroup(groupId);
        this.storeUserObject(userId, ((CommonJsonIdentity)user).asJson());
    }

    @Override
    public void removeUserFromGroup(String groupId, String userId) throws IamSvcException, IamIdentityDoesNotExist, IamGroupDoesNotExist {
        Identity user = this.loadUserOrAlias(userId);
        if (user == null) {
            throw new IamIdentityDoesNotExist("User does not exist: " + userId);
        }
        Group group = this.loadGroup(groupId);
        if (group == null) {
            throw new IamGroupDoesNotExist("Group does not exist: " + groupId);
        }
        ((CommonJsonGroup)group).removeUser(userId);
        ((CommonJsonIdentity)user).removeGroup(groupId);
        this.storeUserObject(userId, ((CommonJsonIdentity)user).asJson());
    }

    @Override
    public Set<String> getUsersGroups(String userId) throws IamSvcException, IamIdentityDoesNotExist {
        Identity user = this.loadUserOrAlias(userId);
        if (user == null) {
            throw new IamIdentityDoesNotExist(userId);
        }
        return ((CommonJsonIdentity)user).getGroupIds();
    }

    @Override
    public Set<String> getUsersInGroup(String groupId) throws IamGroupDoesNotExist, IamSvcException {
        Group g = this.loadGroup(groupId);
        if (g == null) {
            throw new IamGroupDoesNotExist(groupId + " does not exist");
        }
        return ((CommonJsonGroup)g).getMembers();
    }

    @Override
    public G loadGroup(String groupId) throws IamSvcException {
        JSONObject group = this.loadGroupObject(groupId);
        if (group != null) {
            return this.instantiateGroup(groupId, group);
        }
        return null;
    }

    @Override
    public AccessControlList getAclFor(Resource resource) throws IamSvcException {
        if (resource instanceof ProtectedResource) {
            return ((ProtectedResource)resource).getAccessControlList();
        }
        final String resId = resource.getId();
        AclUpdateListener acll = new AclUpdateListener(){

            @Override
            public void onAclUpdate(AccessControlList acl) {
                try {
                    CommonJsonDb.this.storeAclObject(resId, acl.asJson());
                }
                catch (IamSvcException e) {
                    log.warn("Couldn't store ACL: " + e.getMessage());
                }
            }
        };
        JSONObject o = this.loadAclObject(resource.getId());
        if (o == null) {
            if (this.fAclFactory == null) {
                log.warn("No ACL factory established; returning null from getAclFor ( Resource res )");
                return null;
            }
            return this.fAclFactory.createDefaultAcl(acll);
        }
        return AccessControlList.deserialize(o.toString(), acll);
    }

    @Override
    public void onAclUpdate(AccessControlList acl) {
    }

    @Override
    public boolean canUser(String id, Resource resource, String operation) throws IamSvcException {
        AccessControlList acl = this.getAclFor(resource);
        if (acl == null) {
            return true;
        }
        Identity user = this.loadUserOrAlias(id);
        return acl.canUser(id, user.getGroupIds(), operation);
    }

    @Override
    public String createTag(String userId, String appTagType, long duration, TimeUnit durationTimeUnit, String nonce) throws IamSvcException {
        this.removeMatchingTag(userId, appTagType);
        String tagId = UniqueStringGenerator.createUrlKey((String)nonce);
        long expiration = (Clock.now() + TimeUnit.MILLISECONDS.convert(duration, durationTimeUnit)) / 1000L;
        JSONObject entry = new JSONObject().put(kTagId, (Object)tagId).put(kUserId, (Object)userId).put(kTagType, (Object)appTagType).put(kExpireEpoch, expiration);
        this.storeTagObject(tagId, userId, appTagType, entry);
        return tagId;
    }

    @Override
    public String getUserIdForTag(String tagId) throws IamSvcException {
        JSONObject tag = this.loadTagObject(tagId, false);
        return tag == null ? null : tag.getString(kUserId);
    }

    @Override
    public void removeMatchingTag(String userId, String appTagType) throws IamSvcException {
        String tagId = null;
        JSONObject existing = this.loadTagObject(userId, appTagType, true);
        if (existing != null) {
            tagId = existing.getString(kTagId);
        }
        if (tagId != null) {
            this.deleteTagObject(tagId, userId, appTagType);
        }
    }

    @Override
    public void addAlias(String userId, String alias) throws IamSvcException, IamBadRequestException {
        JSONObject entry = new JSONObject().put(kAlias, (Object)alias).put(kUserId, (Object)userId);
        this.storeAliasObject(alias, entry);
    }

    @Override
    public void removeAlias(String alias) throws IamBadRequestException, IamSvcException {
        this.deleteAliasObject(alias);
    }

    @Override
    public Collection<String> getAliasesFor(String userId) throws IamSvcException, IamIdentityDoesNotExist {
        return new TreeSet<String>(this.loadAliasesForUser(userId));
    }

    @Override
    public void addJwtValidator(JwtValidator v) {
        this.fJwtValidators.add(v);
    }

    protected CommonJsonDb() {
        this(null, null);
    }

    protected CommonJsonDb(AclFactory aclMaker, JwtProducer jwtProd) {
        this.fAclFactory = aclMaker == null ? new DefaultAclFactory() : aclMaker;
        this.fJwtTokenFactory = jwtProd;
        this.fJwtValidators = new LinkedList();
        if (this.fJwtTokenFactory != null) {
            this.fJwtValidators.add(this.fJwtTokenFactory);
        }
    }

    public String getAppNonce() {
        return "my app didn't register a nonce";
    }

    public ApiKey createApiKey(String userId) throws IamIdentityDoesNotExist, IamSvcException, IamBadRequestException {
        if (userId == null) {
            throw new IamBadRequestException("A valid user ID is required to create an API key.");
        }
        String appSig = this.getAppNonce();
        String newApiKey = CommonJsonDb.generateKey(16, appSig);
        String newApiSecret = CommonJsonDb.generateKey(24, appSig);
        JSONObject o = this.createApiKeyObject(userId, newApiKey, newApiSecret);
        this.storeApiKeyObject(newApiKey, o);
        return this.instantiateApiKey(newApiKey, this.loadApiKeyObject(newApiKey));
    }

    protected abstract JSONObject createNewUser(String var1);

    protected abstract JSONObject loadUserObject(String var1) throws IamSvcException;

    protected abstract void storeUserObject(String var1, JSONObject var2) throws IamSvcException;

    protected abstract void deleteUserObject(String var1) throws IamSvcException;

    protected abstract I instantiateIdentity(String var1, JSONObject var2);

    protected abstract JSONObject createNewGroup(String var1, String var2);

    protected abstract JSONObject loadGroupObject(String var1) throws IamSvcException;

    protected abstract void storeGroupObject(String var1, JSONObject var2) throws IamSvcException;

    protected abstract void deleteGroupObject(String var1) throws IamSvcException;

    protected abstract G instantiateGroup(String var1, JSONObject var2);

    protected abstract JSONObject createApiKeyObject(String var1, String var2, String var3);

    protected abstract JSONObject loadApiKeyObject(String var1) throws IamSvcException;

    protected abstract void storeApiKeyObject(String var1, JSONObject var2) throws IamSvcException, IamIdentityDoesNotExist, IamBadRequestException;

    protected abstract void deleteApiKeyObject(String var1) throws IamSvcException;

    protected abstract ApiKey instantiateApiKey(String var1, JSONObject var2);

    protected abstract Collection<String> loadApiKeysForUser(String var1) throws IamSvcException, IamIdentityDoesNotExist;

    protected abstract JSONObject loadAclObject(String var1) throws IamSvcException;

    protected abstract void storeAclObject(String var1, JSONObject var2) throws IamSvcException;

    protected abstract void deleteAclObject(String var1) throws IamSvcException;

    protected abstract JSONObject loadTagObject(String var1, boolean var2) throws IamSvcException;

    protected abstract JSONObject loadTagObject(String var1, String var2, boolean var3) throws IamSvcException;

    protected abstract void storeTagObject(String var1, String var2, String var3, JSONObject var4) throws IamSvcException;

    protected abstract void deleteTagObject(String var1, String var2, String var3) throws IamSvcException;

    protected abstract JSONObject loadAliasObject(String var1) throws IamSvcException;

    protected abstract void storeAliasObject(String var1, JSONObject var2) throws IamSvcException, IamBadRequestException;

    protected abstract void deleteAliasObject(String var1) throws IamSvcException;

    protected abstract Collection<String> loadAliasesForUser(String var1) throws IamSvcException, IamIdentityDoesNotExist;

    protected abstract void storeInvalidJwtToken(String var1) throws IamSvcException;

    protected abstract boolean isInvalidJwtToken(String var1) throws IamSvcException;

    public static String generateKey(int length, String nonce) {
        return UniqueStringGenerator.createKeyUsingAlphabet((String)nonce, (String)kKeyChars, (int)length);
    }

    private static void authLog(String msg) {
        log.info(msg);
    }

    private static class DefaultAclFactory
    implements AclFactory {
        private DefaultAclFactory() {
        }

        @Override
        public AccessControlList createDefaultAcl(AclUpdateListener acll) {
            return AccessControlList.initialize(acll);
        }
    }

    public static interface AclFactory {
        public AccessControlList createDefaultAcl(AclUpdateListener var1);
    }
}

