/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl.common.jwt;

import io.continual.builder.Builder;
import io.continual.iam.identity.Identity;
import io.continual.iam.impl.common.jwt.JwtValidator;
import io.continual.util.data.Sha256HmacSigner;
import io.continual.util.data.TypeConvertor;
import io.continual.util.time.Clock;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class JwtProducer
extends JwtValidator {
    private final String fIssuer;
    private final String fSigningKey;
    private final int fDurationSecs;

    public String createJwtToken(Identity ii) {
        JSONObject header = new JSONObject().put("alg", (Object)"HS256").put("typ", (Object)"JWT");
        String encodedHeader = TypeConvertor.base64UrlEncode((String)header.toString());
        JSONObject payload = new JSONObject().put("iss", (Object)this.fIssuer).put("sub", (Object)ii.getId()).put("aud", (Object)new JSONArray().put((Object)this.fIssuer)).put("exp", (Clock.now() + (long)(this.fDurationSecs * 1000)) / 1000L);
        String encodedPayload = TypeConvertor.base64UrlEncode((String)payload.toString());
        String headerAndPayload = encodedHeader + "." + encodedPayload;
        byte[] sigBytes = Sha256HmacSigner.signToBytes((String)headerAndPayload, (String)this.fSigningKey);
        String signature = TypeConvertor.base64UrlEncode((byte[])sigBytes);
        return headerAndPayload + "." + signature;
    }

    @Override
    public List<JwtValidator.SigValidator> getValidators() {
        List<JwtValidator.SigValidator> result = super.getValidators();
        result.add(new JwtValidator.Hs256SigValidator(this.fSigningKey));
        return result;
    }

    protected JwtProducer(Builder b) throws Builder.BuildFailure {
        super(b);
        this.fIssuer = b.fIssuer;
        this.fSigningKey = b.fSigningKey;
        this.fDurationSecs = b.fDurationSecs;
        if (this.fIssuer == null || this.fSigningKey == null) {
            throw new Builder.BuildFailure("An issuer and a key are required to produce JWT tokens.");
        }
    }

    public static class Builder
    extends JwtValidator.Builder {
        private String fIssuer;
        private String fSigningKey;
        private int fDurationSecs = 86400;

        @Override
        public JwtProducer build() throws Builder.BuildFailure {
            return new JwtProducer(this);
        }

        public Builder withIssuerName(String i) {
            this.fIssuer = i;
            super.forIssuer(i);
            super.forAudience(i);
            return this;
        }

        public Builder usingSigningKey(String k) {
            this.fSigningKey = k;
            return this;
        }

        public Builder lasting(int seconds) {
            this.fDurationSecs = seconds;
            return this;
        }
    }
}

