/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.server.data.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import io.committed.invest.server.data.providers.DataProvider;
import io.committed.invest.server.data.query.DataHints;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import reactor.core.publisher.Flux;

public class DatasetProviders {
    private static final List<DataProvider> EMPTY_PROVIDER_LIST = Collections.emptyList();
    private final ImmutableListMultimap<String, DataProvider> providers;

    @Autowired
    public DatasetProviders(List<DataProvider> providers) {
        this.providers = Multimaps.index(providers, DataProvider::getDataset);
    }

    private List<DataProvider> findAllForDataset(String datasetId) {
        ImmutableList list = this.providers.get((Object)datasetId);
        if (list == null || list.isEmpty()) {
            return EMPTY_PROVIDER_LIST;
        }
        return list;
    }

    public Flux<DataProvider> findAll() {
        return Flux.fromIterable((Iterable)this.providers.values());
    }

    public <T> Flux<T> findAll(Class<T> providerClass) {
        return this.findAll().filter(providerClass::isInstance);
    }

    public Flux<DataProvider> findForDataset(String datasetId) {
        return this.findForDataset(datasetId, (DataHints)null);
    }

    public Flux<DataProvider> findForDataset(String datasetId, DataHints hints) {
        List<DataProvider> datasetProviders = this.findAllForDataset(datasetId);
        DataHints dh = this.getHints(hints);
        return dh.apply((Collection<DataProvider>)datasetProviders);
    }

    public <T> Flux<T> findForDataset(String datasetId, Class<T> providerClass) {
        return this.findForDataset(datasetId, providerClass, null);
    }

    public <T> Flux<T> findForDataset(String datasetId, Class<T> providerClass, DataHints hints) {
        return this.findForDataset(datasetId, hints).filter(providerClass::isInstance);
    }

    private DataHints getHints(DataHints hints) {
        return hints != null ? hints : DataHints.DEFAULT;
    }
}

