/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.server.data.services;

import io.committed.invest.server.data.dataset.DataProviderSpecification;
import io.committed.invest.server.data.providers.DataProvider;
import io.committed.invest.server.data.providers.DataProviderFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class DataProviderFactoryRegistry {
    private static final Logger log = LoggerFactory.getLogger(DataProviderFactoryRegistry.class);
    private final List<DataProviderFactory<?>> factories;

    @Autowired
    public DataProviderFactoryRegistry(List<DataProviderFactory<?>> factories) {
        this.factories = factories;
    }

    public Flux<DataProviderFactory<? extends DataProvider>> findFactories(String id) {
        return Flux.fromIterable(this.factories).filter(f -> f.getId().equalsIgnoreCase(id));
    }

    public <P extends DataProvider> Flux<DataProviderFactory<P>> findFactories(String id, Class<P> clazz) {
        return this.findFactories(id).filter(f -> clazz.isAssignableFrom(f.getDataProvider())).map(f -> f);
    }

    public Mono<? extends DataProvider> build(String dataset, DataProviderSpecification spec) {
        Map<Object, Object> safeSettings = spec.getSettings() == null ? Collections.emptyMap() : spec.getSettings();
        String factoryId = spec.getFactory();
        return this.findFactories(factoryId).flatMap(f -> {
            try {
                return f.build(dataset, spec.getDatasource(), safeSettings);
            }
            catch (Exception e) {
                log.warn("Unable to create data provider due to error", (Throwable)e);
                return Mono.empty();
            }
        }).next();
    }
}

