/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.server.data.services;

import io.committed.invest.server.data.dataset.DataProviderSpecification;
import io.committed.invest.server.data.dataset.Dataset;
import io.committed.invest.server.data.providers.DataProvider;
import io.committed.invest.server.data.services.DataProviderFactoryRegistry;
import io.committed.invest.server.data.services.DatasetRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DataProviderCreator {
    private static final Logger log = LoggerFactory.getLogger(DataProviderCreator.class);
    private final DataProviderFactoryRegistry dataProviderFactoryRegistry;

    public DataProviderCreator(DataProviderFactoryRegistry dataProviderFactoryRegistry) {
        this.dataProviderFactoryRegistry = dataProviderFactoryRegistry;
    }

    public Flux<DataProvider> createProviders(DatasetRegistry datasetRegistry) {
        return datasetRegistry.getDatasets().flatMap(this::createProviders);
    }

    public Flux<DataProvider> createProviders(Dataset dataset) {
        return Flux.fromIterable(dataset.getProviders()).flatMap(s -> this.createProvider(dataset, (DataProviderSpecification)s));
    }

    public Mono<? extends DataProvider> createProvider(Dataset dataset, DataProviderSpecification spec) {
        return this.dataProviderFactoryRegistry.build(dataset.getId(), spec);
    }
}

