/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.server.data.query;

import io.committed.invest.server.data.providers.DataProvider;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.function.Function;
import reactor.core.publisher.Flux;

public class DataHints
implements Function<Collection<DataProvider>, Flux<DataProvider>> {
    public static final DataHints DEFAULT = new DataHints(null, null, false);
    private final String database;
    private final String datasource;
    private final boolean duplicate;

    @Override
    public Flux<DataProvider> apply(Collection<DataProvider> input) {
        Flux flux = Flux.fromIterable(input);
        if (this.datasource != null) {
            flux = flux.filter(p -> this.datasource.equals(p.getDatasource()));
        }
        if (this.database != null) {
            flux = flux.filter(p -> this.database.equals(p.getDatabase()));
        }
        if (!this.duplicate) {
            flux = flux.groupBy(DataProvider::getDatasource).flatMap(Flux::next);
        }
        return flux;
    }

    @ConstructorProperties(value={"database", "datasource", "duplicate"})
    public DataHints(String database, String datasource, boolean duplicate) {
        this.database = database;
        this.datasource = datasource;
        this.duplicate = duplicate;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataHints)) {
            return false;
        }
        DataHints other = (DataHints)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$datasource = this.getDatasource();
        String other$datasource = other.getDatasource();
        if (this$datasource == null ? other$datasource != null : !this$datasource.equals(other$datasource)) {
            return false;
        }
        return this.isDuplicate() == other.isDuplicate();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataHints;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $datasource = this.getDatasource();
        result = result * 59 + ($datasource == null ? 43 : $datasource.hashCode());
        result = result * 59 + (this.isDuplicate() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "DataHints(database=" + this.getDatabase() + ", datasource=" + this.getDatasource() + ", duplicate=" + this.isDuplicate() + ")";
    }
}

