/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.server.data;

import io.committed.invest.server.data.dataset.Dataset;
import io.committed.invest.server.data.providers.DataProvider;
import io.committed.invest.server.data.providers.DataProviderFactory;
import io.committed.invest.server.data.services.DataProviderCreator;
import io.committed.invest.server.data.services.DataProviderFactoryRegistry;
import io.committed.invest.server.data.services.DatasetProviders;
import io.committed.invest.server.data.services.DatasetRegistry;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DataCreationConfig {
    private static final Logger log = LoggerFactory.getLogger(DataCreationConfig.class);

    @Bean
    public DatasetProviders datasetProviders(@Autowired(required=false) List<DataProvider> providers) {
        return new DatasetProviders(this.toSafeList(providers, "data providers"));
    }

    @Bean
    public DatasetRegistry datasetRegistry(@Autowired(required=false) List<Dataset> datasets) {
        return new DatasetRegistry(this.toSafeList(datasets, "datasets"));
    }

    @Bean
    public DataProviderFactoryRegistry dataProviderFactoryRegistry(@Autowired(required=false) List<DataProviderFactory<?>> factories) {
        return new DataProviderFactoryRegistry(this.toSafeList(factories, "data provider factories"));
    }

    @Bean
    List<DataProvider> dataProviders(DatasetRegistry datasetRegistry, DataProviderFactoryRegistry dataProviderFactoryRegistry) {
        DataProviderCreator creator = new DataProviderCreator(dataProviderFactoryRegistry);
        return (List)creator.createProviders(datasetRegistry).collect(Collectors.toList()).block();
    }

    private <T> List<T> toSafeList(List<T> providers, String name) {
        List list;
        List list2 = list = providers == null ? Collections.emptyList() : providers;
        if (list.isEmpty()) {
            log.warn("No {} available, no data will be served", (Object)name);
        } else {
            log.warn("{} {} available", (Object)providers.size(), (Object)name);
        }
        return list;
    }
}

