/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.support.elasticsearch;

import io.committed.invest.core.dto.analytic.TimeBin;
import io.committed.invest.core.dto.analytic.Timeline;
import io.committed.invest.core.dto.constants.TimeInterval;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.joda.time.DateTime;
import org.joda.time.Instant;

public class TimeIntervalUtils {
    public static DateHistogramInterval toDateHistogram(TimeInterval interval) {
        if (interval.equals((Object)TimeInterval.YEAR)) {
            return DateHistogramInterval.YEAR;
        }
        if (interval.equals((Object)DateHistogramInterval.MONTH)) {
            return DateHistogramInterval.MONTH;
        }
        if (interval.equals((Object)DateHistogramInterval.DAY)) {
            return DateHistogramInterval.DAY;
        }
        if (interval.equals((Object)DateHistogramInterval.HOUR)) {
            return DateHistogramInterval.HOUR;
        }
        if (interval.equals((Object)DateHistogramInterval.MINUTE)) {
            return DateHistogramInterval.MINUTE;
        }
        if (interval.equals((Object)DateHistogramInterval.SECOND)) {
            return DateHistogramInterval.SECOND;
        }
        return DateHistogramInterval.HOUR;
    }

    public static TimeInterval fromDateHistogram(DateHistogramInterval interval) {
        if (interval.equals((Object)DateHistogramInterval.YEAR)) {
            return TimeInterval.YEAR;
        }
        if (interval.equals((Object)DateHistogramInterval.QUARTER)) {
            return TimeInterval.MONTH;
        }
        if (interval.equals((Object)DateHistogramInterval.MONTH)) {
            return TimeInterval.MONTH;
        }
        if (interval.equals((Object)DateHistogramInterval.WEEK)) {
            return TimeInterval.DAY;
        }
        if (interval.equals((Object)DateHistogramInterval.DAY)) {
            return TimeInterval.DAY;
        }
        if (interval.equals((Object)DateHistogramInterval.HOUR)) {
            return TimeInterval.HOUR;
        }
        if (interval.equals((Object)DateHistogramInterval.MINUTE)) {
            return TimeInterval.MINUTE;
        }
        if (interval.equals((Object)DateHistogramInterval.SECOND)) {
            return TimeInterval.SECOND;
        }
        return TimeInterval.HOUR;
    }

    public static final Timeline create(Histogram histogram, TimeInterval interval) {
        List list = histogram.getBuckets().stream().map(h -> {
            DateTime key = (DateTime)h.getKey();
            Instant jodaInstant = key.toInstant();
            return new TimeBin(java.time.Instant.ofEpochMilli(jodaInstant.getMillis()), h.getDocCount());
        }).collect(Collectors.toList());
        return new Timeline(interval, list);
    }
}

