/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.support.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import org.elasticsearch.action.search.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SourceUtils {
    private static final Logger log = LoggerFactory.getLogger(SourceUtils.class);

    private SourceUtils() {
    }

    public static <T> Flux<T> convertHits(ObjectMapper mapper, SearchResponse r, Class<T> clazz) {
        return Flux.just((Object[])r.getHits().getHits()).flatMap(h -> SourceUtils.convertSource(mapper, h.getSourceAsString(), clazz)).filter(Objects::nonNull);
    }

    public static <T> Mono<T> convertSource(ObjectMapper mapper, String source, Class<T> clazz) {
        try {
            return Mono.just((Object)mapper.readValue(source, clazz));
        }
        catch (Exception e) {
            log.warn("Unable to deserialise source", (Throwable)e);
            return Mono.empty();
        }
    }
}

